/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.eventb;

import de.prob.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ClassicPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Preferences prefNode;
    private Text text;

    public ClassicPreferences() {
    }

    public ClassicPreferences(String title) {
        super(title);
    }

    public ClassicPreferences(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite pageComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        pageComponent.setLayout((Layout)layout);
        Label label = new Label(pageComponent, 0);
        label.setText("Location of ProB Standalone:");
        this.text = new Text(pageComponent, 0);
        String location = this.prefNode.get("location", "");
        this.text.setText(location);
        Button browseButton = new Button(pageComponent, 8);
        browseButton.setText("Browse");
        browseButton.addSelectionListener((SelectionListener)new PushButton(pageComponent.getShell(), this.text));
        Label versionRemark = new Label(pageComponent, 64);
        versionRemark.setText("Note: This needs a version of ProB2-UI (jar file) that is at least 1.0.1 or a version of ProB Tcl/Tk that is at least 1.3.1.\nYou can obtain both from https://prob.hhu.de/w/index.php/Download\n");
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 3;
        versionRemark.setLayoutData((Object)gridData2);
        return pageComponent;
    }

    public boolean performOk() {
        this.prefNode.put("location", this.text.getText());
        try {
            this.prefNode.flush();
        }
        catch (BackingStoreException e) {
            Logger.notifyUser((String)"Failed to save ProB Standalone preferences", (Throwable)e);
        }
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
        this.prefNode = Platform.getPreferencesService().getRootNode().node("instance").node("prob_classic_preferences");
    }

    public static final class PushButton
    extends SelectionAdapter {
        private final Text text;
        private final Shell shell;

        public PushButton(Shell shell, Text text) {
            this.shell = shell;
            this.text = text;
        }

        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            FileDialog dialog = new FileDialog(this.shell, 4096);
            String open = dialog.open();
            open = open.replaceAll(" ", "\\\\ ");
            this.text.setText(open);
        }
    }
}

