/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.errorview;

import de.prob.core.Animator;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import de.prob.ui.StateBasedViewPart;
import de.prob.ui.errorview.ErrorContentProvider;
import de.prob.ui.errorview.ErrorLabelProvider;
import de.prob.ui.errorview.ShownErrors;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class StateErrorView
extends StateBasedViewPart {
    public static final String VIEWID = "de.prob.ui.EventErrorView";
    private TreeViewer errorTree;
    private Text text;
    private final ShownErrors errors = new ShownErrors();

    @Override
    public Control createStatePartControl(Composite parent) {
        SashForm sashForm = new SashForm(parent, 65800);
        this.createErrorTree(sashForm);
        this.text = new Text((Composite)sashForm, 514);
        this.text.setText("");
        this.text.setEditable(false);
        this.errorTree.addSelectionChangedListener((ISelectionChangedListener)new ErrorSelection());
        return sashForm;
    }

    private void createErrorTree(SashForm sashForm) {
        this.errorTree = new TreeViewer((Composite)sashForm);
        this.errorTree.getTree().setHeaderVisible(false);
        this.errorTree.getTree().setLinesVisible(false);
        this.errorTree.setAutoExpandLevel(3);
        TreeViewerColumn col = new TreeViewerColumn(this.errorTree, 16384);
        col.getColumn().setText("Short description");
        col.getColumn().setResizable(true);
        col.getColumn().setWidth(150);
        this.errorTree.setContentProvider((IContentProvider)new ErrorContentProvider());
        this.errorTree.setLabelProvider((IBaseLabelProvider)new ErrorLabelProvider());
        this.errorTree.setInput((Object)this.errors);
    }

    @Override
    public void stateChanged(State currentState, Operation operation) {
        this.errors.update(Animator.getAnimator().getMachineDescription(), currentState);
        this.errorTree.refresh();
    }

    private class ErrorSelection
    implements ISelectionChangedListener {
        private ErrorSelection() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            String msg;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.isEmpty()) {
                msg = "";
            } else {
                Object sel = selection.getFirstElement();
                if (sel instanceof ShownErrors.ShownStateError) {
                    ShownErrors.ShownStateError error = (ShownErrors.ShownStateError)sel;
                    msg = error.getError().getLongDescription();
                } else {
                    msg = "";
                }
            }
            StateErrorView.this.text.setText(msg);
        }
    }
}

