/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui;

import de.prob.core.Animator;
import de.prob.core.IAnimationListener;
import de.prob.core.ILifecycleListener;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import de.prob.ui.StaticListenerRegistry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.part.ViewPart;

public abstract class StateBasedViewPart
extends ViewPart
implements IAnimationListener,
ILifecycleListener {
    private Composite parent;
    private Control noStateMessage;
    private Control stateView;

    protected abstract Control createStatePartControl(Composite var1);

    protected void stateReset() {
    }

    protected void stateChanged(State currentState, Operation operation) {
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        StaticListenerRegistry.registerListener(this);
        StaticListenerRegistry.registerListener(this);
        Animator animator = Animator.getAnimator();
        if (animator.isMachineLoaded()) {
            this.createStateControl();
            State state = animator.getCurrentState();
            Operation op = animator.getHistory().getCurrent().getOperation();
            this.stateChanged(state, op);
        } else {
            this.createNoStateMessage();
            this.reset();
        }
    }

    private void createNoStateMessage() {
        if (this.noStateMessage == null) {
            this.disposeStateView();
            Label message = new Label(this.parent, 0);
            message.setText("no machine available");
            this.noStateMessage = message;
            this.parent.layout();
        }
    }

    private void createStateControl() {
        if (this.stateView == null) {
            this.disposeNoStateMessage();
            this.stateView = this.createStatePartControl(this.parent);
            this.parent.layout();
        }
    }

    private void disposeNoStateMessage() {
        if (this.noStateMessage != null && !this.noStateMessage.isDisposed()) {
            this.noStateMessage.dispose();
        }
        this.noStateMessage = null;
    }

    private void disposeStateView() {
        if (this.stateView != null && !this.stateView.isDisposed()) {
            this.stateView.dispose();
        }
        this.stateView = null;
    }

    public void setFocus() {
        if (this.noStateMessage != null) {
            this.noStateMessage.setFocus();
        }
        if (this.stateView != null) {
            this.stateView.setFocus();
        }
    }

    public final void currentStateChanged(final State currentState, final Operation operation) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StateBasedViewPart.this.createStateControl();
                StateBasedViewPart.this.stateChanged(currentState, operation);
            }
        };
        Display.getDefault().asyncExec(runnable);
    }

    public final void reset() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StateBasedViewPart.this.createNoStateMessage();
                StateBasedViewPart.this.stateReset();
            }
        };
        Display.getDefault().asyncExec(runnable);
    }

    public void dispose() {
        super.dispose();
        StaticListenerRegistry.unregisterListener(this);
        StaticListenerRegistry.unregisterListener(this);
        this.disposeStateView();
        this.disposeNoStateMessage();
    }
}

