/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui;

import de.prob.core.Animator;
import de.prob.core.command.GetPreferencesCommand;
import de.prob.core.domainobjects.ProBPreference;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import de.prob.prolog.term.AIntegerPrologTerm;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProBGeneralPreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final PrologTerm PREF_INT = new CompoundPrologTerm("int");
    private static final PrologTerm PREF_NAT = new CompoundPrologTerm("nat");
    private static final PrologTerm PREF_NAT1 = new CompoundPrologTerm("nat1");
    private static final PrologTerm PREF_BOOL = new CompoundPrologTerm("bool");
    private static final PrologTerm PREF_STRING = new CompoundPrologTerm("string");
    private final Preferences eclipsePrefs;
    private final List<ProBPreference> probPrefs;
    private final ProBPreferenceStore store = new ProBPreferenceStore();

    public ProBGeneralPreferences(Preferences alternateStorage) {
        this.setPreferenceStore((IPreferenceStore)this.store.getStore());
        this.eclipsePrefs = alternateStorage;
        Animator animator = Animator.getAnimator();
        List preferences = Collections.emptyList();
        try {
            try {
                preferences = GetPreferencesCommand.getPreferences((Animator)animator);
            }
            catch (ProBException proBException) {
                this.probPrefs = preferences;
                this.store.load();
            }
        }
        finally {
            this.probPrefs = preferences;
            this.store.load();
        }
    }

    public ProBGeneralPreferences() {
        this.setPreferenceStore((IPreferenceStore)this.store.getStore());
        this.eclipsePrefs = Platform.getPreferencesService().getRootNode().node("instance").node("prob_animation_preferences");
        Animator animator = Animator.getAnimator();
        List preferences = Collections.emptyList();
        try {
            try {
                preferences = GetPreferencesCommand.getPreferences((Animator)animator);
            }
            catch (ProBException proBException) {
                this.probPrefs = preferences;
                this.store.load();
            }
        }
        finally {
            this.probPrefs = preferences;
            this.store.load();
        }
    }

    protected Control createContents(Composite parent) {
        Group group = new Group(parent, 16);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        group.setText("ProB Settings");
        return super.createContents((Composite)group);
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        for (ProBPreference p : this.probPrefs) {
            FieldEditor editor = this.createEditor(p, parent);
            this.addField(editor);
        }
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        super.performOk();
        this.store.save();
        try {
            this.eclipsePrefs.flush();
        }
        catch (BackingStoreException e) {
            String message = "Problem while storing preferences. " + e.getLocalizedMessage();
            Logger.notifyUser((String)message, (Throwable)e);
        }
        return true;
    }

    private FieldEditor createEditor(ProBPreference pref, Composite parent) {
        FieldEditor field;
        PrologTerm type = pref.type;
        String name = pref.name;
        String desc = pref.description;
        if (PREF_INT.equals(type)) {
            field = this.createIntField(name, desc, parent, Integer.MIN_VALUE, Integer.MAX_VALUE);
        } else if (PREF_NAT.equals(type)) {
            field = this.createIntField(name, desc, parent, 0, Integer.MAX_VALUE);
        } else if (PREF_NAT1.equals(type)) {
            field = this.createIntField(name, desc, parent, 1, Integer.MAX_VALUE);
        } else if (PREF_STRING.equals(type)) {
            field = new StringFieldEditor(name, desc, parent);
        } else if (PREF_BOOL.equals(type)) {
            field = new BooleanFieldEditor(name, desc, 1, parent);
        } else if (type.hasFunctor("range", 2)) {
            CompoundPrologTerm range = (CompoundPrologTerm)type;
            BigInteger lower = ((AIntegerPrologTerm)range.getArgument(1)).getValue();
            BigInteger upper = ((AIntegerPrologTerm)range.getArgument(2)).getValue();
            field = this.createIntField(name, desc, parent, lower.intValueExact(), upper.intValueExact());
        } else if (type.isList()) {
            ListPrologTerm typelist = (ListPrologTerm)type;
            String[][] comboEntries = new String[typelist.size()][2];
            int i = 0;
            while (i < typelist.size()) {
                String value;
                comboEntries[i][0] = value = typelist.get(i).toString();
                comboEntries[i][1] = value;
                ++i;
            }
            field = new ComboFieldEditor(name, desc, comboEntries, parent);
        } else {
            field = new StringFieldEditor(name, desc, parent);
        }
        return field;
    }

    private FieldEditor createIntField(String name, String desc, Composite parent, int min, int max) {
        IntegerFieldEditor intfield = new IntegerFieldEditor(name, desc, parent);
        intfield.setValidRange(min, max);
        return intfield;
    }

    public class ProBPreferenceStore {
        private final PreferenceStore store = new PreferenceStore("ProB");

        public void load() {
            for (ProBPreference p : ProBGeneralPreferences.this.probPrefs) {
                this.store.setValue(p.name, ProBGeneralPreferences.this.eclipsePrefs.get(p.name, p.defaultValue));
                this.store.setDefault(p.name, p.defaultValue);
            }
        }

        public void save() {
            for (ProBPreference p : ProBGeneralPreferences.this.probPrefs) {
                ProBGeneralPreferences.this.eclipsePrefs.put(p.name, this.store.getString(p.name));
            }
        }

        public PreferenceStore getStore() {
            return this.store;
        }
    }
}

