/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.stateview.statetree;

import de.prob.core.domainobjects.State;
import de.prob.core.domainobjects.Variable;
import de.prob.ui.stateview.statetree.AbstractStateTreeElement;
import de.prob.ui.stateview.statetree.EStateTreeElementProperty;
import de.prob.ui.stateview.statetree.StateDependendElement;
import de.prob.ui.stateview.statetree.StateTreeElement;
import de.prob.ui.stateview.statetree.StaticStateElement;
import java.util.Objects;

public class StateTreeVariable
extends AbstractStateTreeElement {
    public static final StateTreeVariable[] EMPTY_ARRAY = new StateTreeVariable[0];
    private final String name;
    private final boolean isInMainSection;

    public StateTreeVariable(StaticStateElement parent, String name, boolean isInMainSection) {
        super(parent);
        this.name = name;
        this.isInMainSection = isInMainSection;
    }

    @Override
    public StaticStateElement[] getChildren() {
        return StateTreeElement.EMPTY_ARRAY;
    }

    @Override
    public String getLabel() {
        return this.name;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    public boolean isInMainSection() {
        return this.isInMainSection;
    }

    @Override
    public boolean hasChanged(State current, State last) {
        String lastVal;
        String curVal = this.getValueOfVar(current);
        return !Objects.equals(curVal, lastVal = this.getValueOfVar(last));
    }

    private String getValueOfVar(State state) {
        Variable variable;
        String result = state != null ? ((variable = (Variable)state.getValues().get(this.name)) == null ? null : variable.getValue()) : null;
        return result;
    }

    @Override
    public StateDependendElement getValue(State state) {
        Variable variable = (Variable)state.getValues().get(this.name);
        StateDependendElement element = variable != null ? new StateDependendElement(state, variable.getValue(), EStateTreeElementProperty.NONBOOLEAN) : null;
        return element;
    }
}

