/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.stateview.statetree;

import de.prob.core.domainobjects.EvaluationElement;
import de.prob.core.domainobjects.State;
import de.prob.ui.stateview.statetree.AbstractStateTreeElement;
import de.prob.ui.stateview.statetree.EStateTreeElementProperty;
import de.prob.ui.stateview.statetree.StateDependendElement;
import de.prob.ui.stateview.statetree.StateTreeElement;
import de.prob.ui.stateview.statetree.StateTreeExpression;
import de.prob.ui.stateview.statetree.StaticStateElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StateTreeExpressionSection
extends AbstractStateTreeElement {
    private final String label;
    private final List<StateTreeElement> children;

    public StateTreeExpressionSection(String label, Collection<EvaluationElement> children) {
        this(null, label, children);
    }

    public StateTreeExpressionSection(StaticStateElement parent, String label, Collection<EvaluationElement> children) {
        super(parent);
        this.label = label;
        this.children = new ArrayList<StateTreeElement>(children.size());
        for (EvaluationElement elem : children) {
            StateTreeExpression child = new StateTreeExpression(this, elem);
            this.children.add(child);
        }
    }

    @Override
    public StaticStateElement[] getChildren() {
        return this.children.toArray(StateTreeElement.EMPTY_ARRAY);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public boolean hasChanged(State current, State last) {
        return false;
    }

    public void addChild(EvaluationElement staticElement) {
        StateTreeExpression child = new StateTreeExpression(this, staticElement);
        this.children.add(child);
    }

    @Override
    public StateDependendElement getValue(State state) {
        return new StateDependendElement(state, null, EStateTreeElementProperty.NONBOOLEAN);
    }
}

