/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.stateview;

import de.prob.core.Animator;
import de.prob.core.LanguageDependendAnimationPart;
import de.prob.core.command.EvaluationInsertFormulaCommand;
import de.prob.core.domainobjects.EvaluationElement;
import de.prob.exceptions.ProBException;
import de.prob.parserbase.ProBParseException;
import de.prob.parserbase.ProBParserBase;
import de.prob.parserbase.ProBParserBaseAdapter;
import de.prob.prolog.term.PrologTerm;
import de.prob.ui.stateview.StateViewPart;
import de.prob.ui.stateview.StateViewStrings;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddFormulaHandler
extends AbstractHandler
implements IHandler {
    public Object execute(final ExecutionEvent event) throws ExecutionException {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Animator animator;
                LanguageDependendAnimationPart ldp;
                ProBParserBaseAdapter parser;
                FormulaValidator validator;
                String msg;
                String title;
                Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
                InputDialog dialog = new InputDialog(shell, title = StateViewStrings.dialogTitleEnterNewFormula, msg = StateViewStrings.dialogMessageEnterNewFormula, "", (IInputValidator)(validator = new FormulaValidator(parser = new ProBParserBaseAdapter((ProBParserBase)(ldp = (animator = Animator.getAnimator()).getLanguageDependendPart())))));
                int button = dialog.open();
                if (button == 0) {
                    String entered = dialog.getValue();
                    PrologTerm parsed = null;
                    try {
                        parsed = parser.parsePredicate(entered, false);
                    }
                    catch (ProBParseException proBParseException) {
                        try {
                            parsed = parser.parseExpression(entered, false);
                        }
                        catch (ProBParseException proBParseException2) {
                            MessageDialog.openError((Shell)shell, (String)title, (String)StateViewStrings.dialogSyntaxError);
                        }
                    }
                    if (parsed != null) {
                        try {
                            EvaluationElement staticElement = EvaluationInsertFormulaCommand.insertFormula((PrologTerm)parsed);
                            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            StateViewPart view = (StateViewPart)activePage.findView("de.prob.ui.StateView");
                            if (view != null) {
                                view.addUserDefinedExpression(staticElement);
                            } else {
                                MessageDialog.openError((Shell)shell, (String)"Error", (String)"Unable to access state view");
                            }
                        }
                        catch (ProBException e) {
                            e.notifyUserOnce();
                        }
                    }
                }
            }
        };
        Display.getDefault().asyncExec(runnable);
        return null;
    }

    private static class FormulaValidator
    implements IInputValidator {
        private final ProBParserBaseAdapter parser;

        public FormulaValidator(ProBParserBaseAdapter parser) {
            this.parser = parser;
        }

        public String isValid(String input) {
            String error = null;
            if (input.trim().length() == 0) {
                error = "";
            } else {
                try {
                    this.parser.parsePredicate(input, false);
                }
                catch (ProBParseException e) {
                    String msg = e.getMessage();
                    try {
                        this.parser.parseExpression(input, false);
                    }
                    catch (ProBParseException proBParseException) {
                        error = msg;
                    }
                }
            }
            return error;
        }
    }
}

