/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.refinementcheck;

import de.prob.core.Animator;
import de.prob.core.ProBCommandJob;
import de.prob.core.command.ConstraintBasedRefinementCheckCommand;
import de.prob.core.command.IComposableCommand;
import de.prob.ui.refinementcheck.RefinementCheckFinishedListener;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class RefinementCheckHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        Animator animator = Animator.getAnimator();
        if (animator.isMachineLoaded()) {
            this.performRefinementCheck(animator, shell);
        } else {
            MessageDialog.openError((Shell)shell, (String)"Error: No ProB animation running", (String)"To perform a constraint based refinement check, please start the animation of the model first.");
        }
        return null;
    }

    private void performRefinementCheck(Animator animator, Shell shell) throws ExecutionException {
        ConstraintBasedRefinementCheckCommand command = new ConstraintBasedRefinementCheckCommand();
        ProBCommandJob job = new ProBCommandJob("Performing CBC Refinement Checking", animator, (IComposableCommand)command);
        job.setUser(true);
        job.addJobChangeListener((IJobChangeListener)new RefinementCheckFinishedListener(shell));
        job.schedule();
    }
}

