/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.refinementcheck;

import de.prob.core.Animator;
import de.prob.core.ProBJobFinishedListener;
import de.prob.core.command.ConstraintBasedRefinementCheckCommand;
import de.prob.core.command.IComposableCommand;
import de.prob.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class RefinementCheckFinishedListener
extends ProBJobFinishedListener {
    private final Shell shell;

    public RefinementCheckFinishedListener(Shell shell) {
        this.shell = shell;
    }

    protected void showResult(IComposableCommand command, Animator animator) {
        String message;
        String dialogTitle;
        int dialogType;
        ConstraintBasedRefinementCheckCommand refCmd = (ConstraintBasedRefinementCheckCommand)command;
        ConstraintBasedRefinementCheckCommand.ResultType result = refCmd.getResult();
        switch (result) {
            case INTERRUPTED: {
                dialogType = 4;
                dialogTitle = "User Interrupt";
                message = "The refinement check has been interrupted by the user.";
                break;
            }
            case NO_VIOLATION_FOUND: {
                dialogType = 2;
                dialogTitle = "No Refinement Violation found";
                message = "No possible refinement violation has been found.";
                break;
            }
            case VIOLATION_FOUND: {
                dialogType = 1;
                dialogTitle = "Refinement Violation found";
                message = refCmd.getResultsString();
                break;
            }
            default: {
                Logger.notifyUser((String)("Unexpected result: " + String.valueOf(result)));
                return;
            }
        }
        if (this.shell.isDisposed()) {
            System.out.println("Refinement Check finished: " + dialogTitle);
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    MessageDialog.open((int)dialogType, (Shell)RefinementCheckFinishedListener.this.shell, (String)dialogTitle, (String)message, (int)0);
                }
            };
            this.shell.getDisplay().asyncExec(runnable);
        }
    }
}

