/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.operationview;

import de.prob.core.Animator;
import de.prob.core.domainobjects.Operation;
import de.prob.ui.ProbUiPlugin;
import de.prob.ui.operationview.OperationTableViewer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

class OperationsLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final OperationTableViewer operationTableViewer;
    private final Image imgDisabled = ProbUiPlugin.getDefault().getImageRegistry().getDescriptor("IMG_DISABLED").createImage();
    private final Image imgTimeout = ProbUiPlugin.getDefault().getImageRegistry().getDescriptor("IMG_TIMEOUT").createImage();
    private final Image imgEnabled = ProbUiPlugin.getDefault().getImageRegistry().getDescriptor("IMG_ENABLED").createImage();
    private static final char TIMES = '\u00d7';

    public OperationsLabelProvider(OperationTableViewer operationTableViewer) {
        this.operationTableViewer = operationTableViewer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof String) {
                boolean timeout = Animator.getAnimator().getCurrentState().isTimeoutOp((String)element);
                if (timeout) {
                    return this.imgTimeout;
                }
                return this.imgDisabled;
            }
            if (element instanceof ArrayList) {
                return this.imgEnabled;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ArrayList ops;
        if (columnIndex == 0) {
            if (element instanceof String) {
                return (String)element;
            }
            if (element instanceof List) {
                List ops2 = (List)element;
                Operation op = (Operation)ops2.get(0);
                int size = ops2.size();
                if (size > 1) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(op.getName());
                    sb.append(" (").append('\u00d7');
                    sb.append(size).append(')');
                    return sb.toString();
                }
                return op.getName();
            }
        }
        if (columnIndex == 1 && element instanceof ArrayList && (ops = (ArrayList)element).size() > 0) {
            Operation op = (Operation)ops.get(0);
            List args = op.getArguments();
            int columnWidth = this.operationTableViewer.getViewer().getTable().getColumn(columnIndex).getWidth();
            return OperationTableViewer.convertParamsToString(columnWidth / 6 / Math.max(args.size(), 1), columnWidth / 6, args);
        }
        return "";
    }
}

