/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.operationview;

import de.prob.core.Animator;
import de.prob.core.command.GetOperationNamesCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.OperationInfo;
import de.prob.exceptions.ProBException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class OperationSelectionDialog
extends TrayDialog {
    private static final String IMG_CHECKED = "icons/checked.gif";
    private static final String IMG_UNCHECKED = "icons/unchecked.gif";
    private static final int MIN_ARGUMENT_LENGTH = 20;
    private String shellTitle = "";
    private final Animator animator;
    private final List<String> arguments = new ArrayList<String>();
    private List<Operation> enabledOperations = null;
    private final List<Boolean> hiddenColumns = new ArrayList<Boolean>();
    private final List<Object> hiddenArguments = new ArrayList<Object>();
    private Button btSwitchOperation = null;
    private TableViewer tbvOps;
    private TableViewer argRepTable;
    private Operation lastSelectedOperation = null;
    private boolean opsHidden = false;

    public OperationSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.animator = Animator.getAnimator();
    }

    protected void okPressed() {
        IStructuredSelection sel = (IStructuredSelection)this.tbvOps.getSelection();
        OperationEntry entry = (OperationEntry)sel.getFirstElement();
        this.lastSelectedOperation = entry.getOperation();
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setSize(400, 500);
        newShell.setText("Select Operation: " + this.shellTitle);
    }

    public void setTitle(String title) {
        this.shellTitle = title;
    }

    protected Control createContents(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(1808));
        contents.setLayout((Layout)new GridLayout());
        this.dialogArea = this.createDialogArea(contents);
        this.buttonBar = this.createButtonBar(contents);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayoutData((Object)new GridData(1808));
        content.setLayout((Layout)new FormLayout());
        Sash sash = new Sash(content, 256);
        boolean argumentsAreShortened = this.argumentsAreShortened();
        FormData data = new FormData();
        data.top = argumentsAreShortened ? new FormAttachment(50, 0) : new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        sash.setLayoutData((Object)data);
        Group gpOperations = new Group(content, 16);
        gpOperations.setText("Operations");
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment((Control)sash, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        gpOperations.setLayoutData((Object)data);
        gpOperations.setLayout((Layout)new GridLayout(1, false));
        Composite tableComp = new Composite((Composite)gpOperations, 0);
        tableComp.setLayoutData((Object)new GridData(1808));
        tableComp.setLayout((Layout)new FillLayout());
        this.createOperationsTable(tableComp);
        if (argumentsAreShortened) {
            Group gpArgRep = new Group(content, 16);
            gpArgRep.setText("Argument replacements");
            data = new FormData();
            data.top = new FormAttachment((Control)sash, 0);
            data.bottom = new FormAttachment(100, 0);
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            gpArgRep.setLayoutData((Object)data);
            gpArgRep.setLayout((Layout)new GridLayout(1, false));
            Composite tableComp2 = new Composite((Composite)gpArgRep, 0);
            tableComp2.setLayoutData((Object)new GridData(1808));
            tableComp2.setLayout((Layout)new FillLayout());
            this.createArgReplacementTable(tableComp2);
        }
        this.btSwitchOperation = new Button((Composite)gpOperations, 8);
        this.btSwitchOperation.setText("Show/Hide equal columns");
        this.btSwitchOperation.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OperationSelectionDialog.this.hideSameArguments();
            }
        });
        return content;
    }

    private Operation getSelectedOperation() {
        return this.lastSelectedOperation;
    }

    public static Operation getOperation(List<Operation> list) {
        String shellTitle = "";
        if (list.get(0) != null) {
            shellTitle = list.get(0).getName();
        }
        OperationSelectionDialog osd = new OperationSelectionDialog(new Shell());
        osd.setTitle(shellTitle);
        osd.setEnabledOperations(list);
        if (osd.open() == 0) {
            return osd.getSelectedOperation();
        }
        return null;
    }

    private boolean argumentsAreShortened() {
        for (Operation op : this.getEnabledOperations()) {
            for (String arg : op.getArguments()) {
                if (arg.length() <= 20) continue;
                return true;
            }
        }
        return false;
    }

    private void hideSameArguments() {
        if (!this.opsHidden) {
            List<Operation> opList = this.getEnabledOperations();
            Operation firstOp = opList.get(0);
            int i = 0;
            while (i < firstOp.getArguments().size()) {
                boolean valuesAreEqual = this.allValuesAreEqual(opList, i);
                this.hiddenColumns.set(i, valuesAreEqual);
                ++i;
            }
        } else {
            ListIterator<Boolean> l = this.hiddenColumns.listIterator();
            while (l.hasNext()) {
                l.next();
                l.set(false);
            }
        }
        this.opsHidden = !this.opsHidden;
        this.tbvOps.refresh();
        this.packTableColumns(this.tbvOps);
    }

    private boolean allValuesAreEqual(Collection<Operation> operations, int argNum) {
        if (operations.isEmpty()) {
            return true;
        }
        String firstArg = null;
        for (Operation op : operations) {
            String curArg = (String)op.getArguments().get(argNum);
            if (firstArg == null) {
                firstArg = curArg;
                continue;
            }
            if (firstArg.equals(curArg)) continue;
            return false;
        }
        return true;
    }

    private void setEnabledOperations(List<Operation> al) {
        this.enabledOperations = al;
    }

    private List<Operation> getEnabledOperations() {
        if (this.enabledOperations == null) {
            this.enabledOperations = this.animator.getCurrentState().getEnabledOperations();
        }
        return this.enabledOperations;
    }

    private List<String> getOperationParams(Operation op) {
        ArrayList<String> result;
        OperationInfo params;
        List infos = null;
        try {
            infos = GetOperationNamesCommand.getNames((Animator)this.animator);
        }
        catch (ProBException e) {
            e.notifyUserOnce();
        }
        OperationInfo operationInfo = params = infos == null ? null : OperationInfo.getParams((String)op.getName(), (Collection)infos);
        if (params != null) {
            result = params.getParameters();
        } else {
            int numArgs = op.getArguments().size();
            result = new ArrayList<String>(numArgs);
            int i = 0;
            while (i < numArgs) {
                result.add("");
                ++i;
            }
        }
        return result;
    }

    private void createArgReplacementTable(Composite parent) {
        this.argRepTable = new TableViewer(parent, 68356);
        this.createArgReplacmentColumns(this.argRepTable);
        this.argRepTable.setContentProvider((IContentProvider)new ArgRepContentProvider());
        this.argRepTable.setLabelProvider((IBaseLabelProvider)new ArgRepLabelProvider());
        this.argRepTable.setInput(this.getEnabledOperations());
        this.packTableColumns(this.argRepTable);
    }

    private void createArgReplacmentColumns(final TableViewer tbViewer) {
        TableViewerColumn hide = new TableViewerColumn(tbViewer, 0);
        hide.getColumn().setText("!");
        hide.getColumn().setResizable(true);
        hide.setEditingSupport(new EditingSupport((ColumnViewer)tbViewer){

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor((Composite)tbViewer.getTable());
            }

            protected Object getValue(Object element) {
                if (OperationSelectionDialog.this.hiddenArguments.contains(element)) {
                    OperationSelectionDialog.this.hiddenArguments.remove(element);
                } else {
                    OperationSelectionDialog.this.hiddenArguments.add(element);
                }
                tbViewer.refresh(element);
                OperationSelectionDialog.this.tbvOps.refresh();
                OperationSelectionDialog.this.packTableColumns(OperationSelectionDialog.this.tbvOps);
                return null;
            }

            protected void setValue(Object element, Object value) {
            }
        });
        TableViewerColumn repl = new TableViewerColumn(tbViewer, 0);
        repl.getColumn().setText("Repl.");
        repl.getColumn().setResizable(true);
        TableViewerColumn org = new TableViewerColumn(tbViewer, 0);
        org.getColumn().setText("Original");
        org.getColumn().setResizable(true);
        Table table = tbViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    private void createOperationsTable(Composite parent) {
        this.tbvOps = new TableViewer(parent, 68356);
        List<Operation> opList = this.getEnabledOperations();
        List<String> params = this.getOperationParams(opList.get(0));
        if (params.size() == 0) {
            params = new ArrayList<String>();
            params.add("");
        }
        this.createOperationsTableColumns(this.tbvOps, params);
        this.tbvOps.setContentProvider((IContentProvider)new OperationsContentProvider());
        this.tbvOps.setLabelProvider((IBaseLabelProvider)new OperationsLabelProvider());
        this.tbvOps.setInput(opList);
        this.tbvOps.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                OperationSelectionDialog.this.okPressed();
            }
        });
        this.packTableColumns(this.tbvOps);
    }

    private void createOperationsTableColumns(final TableViewer tbViewer, List<String> params) {
        int count = 0;
        for (String string : params) {
            final int index = count++;
            this.hiddenColumns.add(false);
            TableViewerColumn column = new TableViewerColumn(tbViewer, 0);
            column.getColumn().setText(string);
            column.getColumn().setResizable(true);
            column.getColumn().pack();
            column.getColumn().addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    OperationSelectionDialog.this.hiddenColumns.set(index, OperationSelectionDialog.this.hiddenColumns.get(index) == false);
                    tbViewer.refresh();
                    OperationSelectionDialog.this.packTableColumns(tbViewer);
                }

                public void widgetSelected(SelectionEvent e) {
                }
            });
        }
        Table table = tbViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    private void packTableColumns(TableViewer tbViewer) {
        TableColumn[] tableColumnArray = tbViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            col.pack();
            ++n2;
        }
    }

    private String getReplacementString(int index) {
        return "[" + index + "]";
    }

    private class ArgRepContentProvider
    implements IStructuredContentProvider {
        private ArgRepContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            List operations = (List)inputElement;
            for (Operation op : operations) {
                for (String arg : op.getArguments()) {
                    if (arg.length() <= 20 || OperationSelectionDialog.this.arguments.contains(arg)) continue;
                    OperationSelectionDialog.this.arguments.add(arg);
                }
            }
            return OperationSelectionDialog.this.arguments.toArray();
        }
    }

    private class ArgRepLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ArgRepLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (OperationSelectionDialog.this.hiddenArguments.contains(element)) {
                    return AbstractUIPlugin.imageDescriptorFromPlugin((String)"de.prob.ui", (String)OperationSelectionDialog.IMG_CHECKED).createImage();
                }
                return AbstractUIPlugin.imageDescriptorFromPlugin((String)"de.prob.ui", (String)OperationSelectionDialog.IMG_UNCHECKED).createImage();
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 1) {
                int index = OperationSelectionDialog.this.arguments.indexOf(element);
                return OperationSelectionDialog.this.getReplacementString(index);
            }
            if (columnIndex == 2) {
                return (String)element;
            }
            return "";
        }
    }

    private static class OperationEntry {
        private final Operation operation;
        private final int position;

        public OperationEntry(Operation operation, int position) {
            this.operation = operation;
            this.position = position;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public int getPosition() {
            return this.position;
        }

        public boolean isInternalNondeterminism() {
            return this.operation.getArguments().isEmpty();
        }
    }

    private static class OperationsContentProvider
    implements IStructuredContentProvider {
        private OperationsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            List operations = (List)inputElement;
            Object[] elements = new OperationEntry[operations.size()];
            int pos = 0;
            for (Operation op : operations) {
                elements[pos] = new OperationEntry(op, pos);
                ++pos;
            }
            return elements;
        }
    }

    private class OperationsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private OperationsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (OperationSelectionDialog.this.hiddenColumns.get(columnIndex).booleanValue()) {
                return "-";
            }
            OperationEntry entry = (OperationEntry)element;
            if (!entry.isInternalNondeterminism()) {
                Operation op = entry.getOperation();
                String argument = (String)op.getArguments().get(columnIndex);
                if (OperationSelectionDialog.this.hiddenArguments.contains(argument)) {
                    return OperationSelectionDialog.this.getReplacementString(OperationSelectionDialog.this.arguments.indexOf(argument));
                }
                return argument;
            }
            return "Non-deterministic choice #" + entry.getPosition();
        }
    }
}

