/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.operationview;

import de.be4.classicalb.core.parser.analysis.prolog.ASTProlog;
import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.be4.classicalb.core.parser.node.Switch;
import de.prob.core.Animator;
import de.prob.core.ProblemHandler;
import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.eval.PredicateEvalElement;
import de.prob.exceptions.ProBException;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.ArrayList;
import java.util.List;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.IParseResult;
import org.eventb.core.ast.Predicate;

public final class GetOperationByPredicateCommand2
implements IComposableCommand {
    private static final String NEW_STATE_ID_VARIABLE = "NewStateID";
    private final PredicateEvalElement evalElement;
    private final String stateId;
    private final String name;
    private List<Operation> operation;
    private final int nrOfSolutions;

    private GetOperationByPredicateCommand2() {
        throw new UnsupportedOperationException("Do not call this constructor");
    }

    private GetOperationByPredicateCommand2(String stateId, String name, String predicate, int nrOfSolutions) throws CommandException {
        this.stateId = stateId;
        this.name = name;
        this.nrOfSolutions = nrOfSolutions;
        PredicateEvalElement parsedEvalElement = null;
        IParseResult result = FormulaFactory.getDefault().parsePredicate(predicate, null);
        Predicate parsedPredicate = result.getParsedPredicate();
        try {
            try {
                parsedEvalElement = PredicateEvalElement.fromRodin((Predicate)parsedPredicate);
            }
            catch (BCompoundException bCompoundException) {
                String message = "Fatal error when trying to parse " + predicate + ". Execution of event " + name + " aborted.";
                ProblemHandler.raiseCommandException((String)message);
                this.evalElement = parsedEvalElement = null;
            }
        }
        finally {
            this.evalElement = parsedEvalElement;
        }
    }

    public static Operation getOperation(Animator a, String stateId, String name, String predicate) throws ProBException, BCompoundException {
        List<Operation> operations = GetOperationByPredicateCommand2.getOperations(a, stateId, name, predicate, 1);
        return operations == null ? null : operations.get(0);
    }

    public static List<Operation> getOperations(Animator a, String stateId, String name, String predicate, int nrOfSolutions) throws ProBException, BCompoundException {
        GetOperationByPredicateCommand2 executeOperationCommand = new GetOperationByPredicateCommand2(stateId, name, predicate, nrOfSolutions);
        if (executeOperationCommand.evalElement != null) {
            a.execute((IComposableCommand)executeOperationCommand);
        }
        return executeOperationCommand.getOperation();
    }

    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("execute_custom_operations").printAtomOrNumber(this.stateId).printAtom(this.name);
        ASTProlog prolog = new ASTProlog(pto, null);
        this.evalElement.getPrologAst().apply((Switch)prolog);
        pto.printNumber((long)this.nrOfSolutions);
        pto.printVariable(NEW_STATE_ID_VARIABLE);
        pto.printVariable("Errors").closeTerm();
    }

    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        ListPrologTerm list = (ListPrologTerm)bindings.get((Object)NEW_STATE_ID_VARIABLE);
        if (list.isEmpty()) {
            this.operation = null;
        } else {
            ArrayList<Operation> result = new ArrayList<Operation>();
            for (PrologTerm prologTerm : list) {
                Operation op = Operation.fromPrologTerm((PrologTerm)prologTerm);
                result.add(op);
            }
            this.operation = result;
        }
    }

    private List<Operation> getOperation() {
        return this.operation;
    }
}

