/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.operationview;

import de.prob.core.Animator;
import de.prob.core.command.ExecuteOperationCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import de.prob.ui.operationview.OperationTableViewer;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;

public class ExecuteEventHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        long id = -1L;
        try {
            id = Long.parseLong(event.getParameter("de.prob.ui.operation"));
        }
        catch (NumberFormatException e) {
            Logger.notifyUser((String)"Internal Error. Please submit a bugreport", (Throwable)e);
        }
        Logger.assertProB((String)"id >= 0", (id >= 0L ? 1 : 0) != 0);
        List<Operation> operations = OperationTableViewer.getInstance().getSelectedOperations();
        if (operations.isEmpty()) {
            return null;
        }
        for (Operation operation : operations) {
            long cid = operation.getId();
            if (cid != id) continue;
            try {
                ExecuteOperationCommand.executeOperation((Animator)Animator.getAnimator(), (Operation)operation);
            }
            catch (ProBException e) {
                e.notifyUserOnce();
                throw new ExecutionException("executing the event failed", (Throwable)e);
            }
        }
        return null;
    }
}

