/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.ltl;

import de.prob.core.command.LtlCheckingCommand;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.ui.ltl.LtlCheckingFinishedListener;
import de.prob.ui.ltl.LtlCheckingJob;
import de.prob.ui.ltl.LtlStrings;
import java.util.List;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public final class LtlMultiCheckingFinishedListener
extends LtlCheckingFinishedListener {
    private final List<String> formulas;
    private int formulaCount = 0;
    private boolean counterExampleFound = false;

    public LtlMultiCheckingFinishedListener(Shell shell, List<String> formulas) {
        super(shell);
        this.formulas = formulas;
    }

    @Override
    public synchronized void done(IJobChangeEvent event) {
        LtlCheckingJob ltlJob;
        Job job = event.getJob();
        if (job instanceof LtlCheckingJob && !(ltlJob = (LtlCheckingJob)job).isAnErrorOccurred()) {
            Runnable runnable;
            final LtlCheckingCommand.Result result = ltlJob.getModelCheckingResult();
            ++this.formulaCount;
            switch (result.getStatus()) {
                case counterexample: {
                    this.counterExampleFound = true;
                    runnable = new Runnable(){

                        @Override
                        public void run() {
                            ListPrologTerm counterExample = result.getCounterexample();
                            if (counterExample != null) {
                                LtlMultiCheckingFinishedListener.this.showCounterexampleInView(result);
                            }
                        }
                    };
                    this.shell.getDisplay().asyncExec(runnable);
                }
            }
            if (this.formulaCount == this.formulas.size()) {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        int displayType;
                        String message;
                        String title;
                        if (LtlMultiCheckingFinishedListener.this.counterExampleFound) {
                            title = LtlStrings.ltlResultCounterexampleTitle;
                            message = LtlStrings.ltlMultiResultCounterexampleMessage;
                            displayType = 1;
                        } else {
                            title = LtlStrings.ltlResultOkTitle;
                            message = LtlStrings.ltlMultiResultOkMessage;
                            displayType = 2;
                        }
                        MessageDialog.open((int)displayType, (Shell)LtlMultiCheckingFinishedListener.this.shell, (String)title, (String)message, (int)0);
                    }
                };
                this.shell.getDisplay().asyncExec(runnable);
            }
        }
    }
}

