/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.ltl;

import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.logging.Logger;
import de.prob.ui.StateBasedViewPart;
import de.prob.ui.ltl.CounterExampleLoadedProvider;
import de.prob.ui.ltl.CounterExampleTab;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.services.ISourceProviderService;

public final class CounterExampleViewPart
extends StateBasedViewPart {
    private static final String ID = "de.prob.ui.ltl.CounterExampleView";
    private static final String DATA_KEY = "tabdata";
    private CTabFolder tabFolder;
    private ViewType viewType = ViewType.INTERACTIVE;

    public static CounterExampleViewPart showDefault() {
        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        CounterExampleViewPart counterExampleView = null;
        try {
            counterExampleView = (CounterExampleViewPart)workbenchPage.showView(ID);
        }
        catch (PartInitException e) {
            Logger.notifyUser((String)"Failed to show the LTL view.", (Throwable)e);
        }
        return counterExampleView;
    }

    public static CounterExampleViewPart getDefault() {
        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        return (CounterExampleViewPart)workbenchPage.findView(ID);
    }

    @Override
    protected Control createStatePartControl(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 2048);
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                if (CounterExampleViewPart.this.tabFolder.getItemCount() == 1) {
                    CounterExampleViewPart.this.updateCounterExampleLoadedProvider(false);
                }
            }
        });
        return this.tabFolder;
    }

    public void addCounterExample(final CounterExample counterExample) {
        this.initializeMenuSetting();
        this.updateCounterExampleLoadedProvider(true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CTabItem tabItem = CounterExampleViewPart.this.createTabItem(counterExample);
                CounterExampleViewPart.this.tabFolder.setSelection(tabItem);
                CounterExampleViewPart.this.tabFolder.update();
            }
        };
        Display.getDefault().asyncExec(runnable);
    }

    private void initializeMenuSetting() {
        MenuManager manager;
        if (this.tabFolder.getItemCount() == 0 && (manager = (MenuManager)this.getViewSite().getActionBars().getMenuManager()).getSize() > 0 && manager.getItems()[0] instanceof MenuManager && (manager = (MenuManager)manager.getItems()[0]).getSize() > 0 && manager.getItems()[0] instanceof CommandContributionItem) {
            CommandContributionItem item = (CommandContributionItem)manager.getItems()[0];
            ParameterizedCommand parameterizedCommand = item.getCommand();
            Command command = parameterizedCommand.getCommand();
            try {
                HandlerUtil.updateRadioState((Command)command, (String)this.viewType.name());
            }
            catch (ExecutionException executionException) {}
        }
    }

    public void zoomInCounterExample() {
        CounterExampleTab tab = this.getCurrentTab();
        if (tab != null) {
            tab.zoomIn();
        }
    }

    public void zoomOutCounterExample() {
        CounterExampleTab tab = this.getCurrentTab();
        if (tab != null) {
            tab.zoomOut();
        }
    }

    public void printCounterExample() {
        CounterExampleTab tab = this.getCurrentTab();
        if (tab != null) {
            tab.printCounterExample(this.getTitle());
        }
    }

    public void setViewType(ViewType viewType) {
        this.viewType = viewType;
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem tabItem = cTabItemArray[n2];
            CounterExampleTab tab = this.getTab(tabItem);
            tab.updateTopControl(viewType);
            ++n2;
        }
    }

    public int getCurrentIndex() {
        CounterExampleTab tab = this.getCurrentTab();
        return tab != null ? tab.getCurrentIndex() : -1;
    }

    @Override
    protected void stateChanged(State activeState, Operation operation) {
        CounterExampleTab tab = this.getCurrentTab();
        if (tab != null) {
            tab.stateChanged(activeState, operation);
        }
    }

    @Override
    protected void stateReset() {
        super.stateReset();
        this.updateCounterExampleLoadedProvider(false);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.updateCounterExampleLoadedProvider(false);
    }

    public CounterExample getCurrentCounterExample() {
        CounterExampleTab data = this.getCurrentTab();
        return data == null ? null : data.getCounterExample();
    }

    private void updateCounterExampleLoadedProvider(boolean enabled) {
        ISourceProviderService service = (ISourceProviderService)this.getSite().getService(ISourceProviderService.class);
        CounterExampleLoadedProvider provider = (CounterExampleLoadedProvider)service.getSourceProvider("de.prob.ui.ltl.counterexample_loaded");
        provider.setEnabled(enabled);
    }

    private CTabItem createTabItem(CounterExample counterExample) {
        CounterExampleTab ceTab = new CounterExampleTab(this.tabFolder, counterExample);
        CTabItem tabItem = ceTab.getTabitem();
        tabItem.setData(DATA_KEY, (Object)ceTab);
        ceTab.updateTopControl(this.viewType);
        return tabItem;
    }

    private CounterExampleTab getCurrentTab() {
        CounterExampleTab tab;
        if (this.tabFolder != null) {
            CTabItem selection = this.tabFolder.getSelection();
            tab = this.getTab(selection);
        } else {
            tab = null;
        }
        return tab;
    }

    private CounterExampleTab getTab(CTabItem item) {
        return item == null ? null : (CounterExampleTab)item.getData(DATA_KEY);
    }

    public static enum ViewType {
        INTERACTIVE,
        TREE,
        TABLE;

    }
}

