/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.historyview;

import de.prob.core.Animator;
import de.prob.core.domainobjects.History;
import de.prob.core.domainobjects.HistoryItem;
import de.prob.core.domainobjects.MachineDescription;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import de.prob.ui.StateBasedViewPart;
import de.prob.ui.dnd.StaticStateElementTransfer;
import de.prob.ui.historyview.HistoryElementLabelProvider;
import de.prob.ui.historyview.HistoryEventLabelProvider;
import de.prob.ui.historyview.HistoryLabelProvider;
import de.prob.ui.stateview.statetree.StaticStateElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class HistoryView
extends StateBasedViewPart {
    public static final String VIEW_ID = "de.prob.ui.HistoryView";
    private TableViewer tableViewer;
    private Collection<HistoryLabelProvider> labelProviders;

    @Override
    protected Control createStatePartControl(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        this.tableViewer = new TableViewer(tableComposite, 0);
        this.tableViewer.setContentProvider((IContentProvider)new HistContentProvider());
        this.tableViewer.addDoubleClickListener((IDoubleClickListener)new HistDoubleClickListener());
        this.createColumns(tableComposite);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.setPaintListener(table);
        this.initDragAndDrop();
        return tableComposite;
    }

    private void setPaintListener(final Table table) {
        final Color activecolor = Display.getDefault().getSystemColor(9);
        final Color samecolor = Display.getDefault().getSystemColor(15);
        table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                HistViewItem item = (HistViewItem)event.item.getData();
                if (item != null) {
                    if (item.followingStateIsActive()) {
                        this.drawLine(table, event, true, activecolor);
                    } else if (item.followingStateIsSameAsCurrent()) {
                        this.drawLine(table, event, true, samecolor);
                    }
                    if (item.previousStateIsActive()) {
                        this.drawLine(table, event, false, activecolor);
                    } else if (item.previousStateIsSameAsCurrent()) {
                        this.drawLine(table, event, false, samecolor);
                    }
                }
            }

            private void drawLine(Table table2, Event event, boolean onTop, Color color) {
                int clientWidth = table2.getClientArea().width;
                GC gc = event.gc;
                int y = onTop ? event.y : event.y + event.height - 1;
                gc.setBackground(color);
                gc.fillRectangle(event.x, y, clientWidth, 1);
            }
        });
    }

    private void initDragAndDrop() {
        Transfer[] transferTypes = new Transfer[]{StaticStateElementTransfer.getInstance()};
        ViewerDropAdapter dropListener = new ViewerDropAdapter((Viewer)this.tableViewer){

            public boolean validateDrop(Object target, int type, TransferData transferData) {
                boolean isSupported = StaticStateElementTransfer.getInstance().isSupportedType(transferData);
                return isSupported;
            }

            public boolean performDrop(Object data) {
                return data != null && data instanceof StaticStateElement[];
            }
        };
        this.tableViewer.addDropSupport(3, transferTypes, (DropTargetListener)dropListener);
    }

    public void addColumns(final Collection<StaticStateElement> elements) {
        Runnable update = new Runnable(){

            @Override
            public void run() {
                Composite parent = HistoryView.this.tableViewer.getTable().getParent();
                TableColumnLayout layout = (TableColumnLayout)parent.getLayout();
                for (StaticStateElement element : elements) {
                    HistoryView.this.createColumn(layout, element.getLabel(), new HistoryElementLabelProvider(element), false);
                }
                parent.layout();
                parent.redraw();
                HistoryView.this.tableViewer.refresh();
            }
        };
        Display.getDefault().asyncExec(update);
    }

    private void createColumns(Composite composite) {
        List<String> models;
        Animator animator = Animator.getAnimator();
        MachineDescription machineDescription = animator.getMachineDescription();
        if (machineDescription != null) {
            models = new ArrayList<String>(machineDescription.getModelNames());
            Collections.reverse(models);
        } else {
            models = Collections.emptyList();
        }
        TableColumnLayout layout = new TableColumnLayout();
        composite.setLayout((Layout)layout);
        this.labelProviders = new ArrayList<HistoryLabelProvider>();
        if (!models.isEmpty()) {
            int pos = 0;
            for (String model : models) {
                boolean isFirst = pos == 0;
                HistoryEventLabelProvider labelProvider = new HistoryEventLabelProvider(pos);
                this.createColumn(layout, model, labelProvider, isFirst);
                ++pos;
            }
        } else {
            this.createColumn(layout, "Event", new HistoryEventLabelProvider(0), false);
        }
    }

    private void createColumn(TableColumnLayout layout, String header, HistoryLabelProvider labelProvider, boolean setMinimumSize) {
        TableViewerColumn tvc = new TableViewerColumn(this.tableViewer, 0);
        tvc.setLabelProvider((CellLabelProvider)labelProvider);
        TableColumn column = tvc.getColumn();
        column.setText(header);
        column.setResizable(true);
        column.setMoveable(true);
        ColumnWeightData weightData = setMinimumSize ? new ColumnWeightData(1, 100) : new ColumnWeightData(1);
        layout.setColumnData((Widget)column, (ColumnLayoutData)weightData);
        this.labelProviders.add(labelProvider);
    }

    @Override
    protected void stateChanged(State currentState, Operation operation) {
        HistViewItem current;
        Animator animator = Animator.getAnimator();
        History history = animator.getHistory();
        HistoryItem[] items = history.getAllItems();
        int size = items.length;
        HistViewItem[] vItems = new HistViewItem[size];
        if (size > 0) {
            int activeItem = history.getCurrentPosition();
            State cs = items[activeItem].getState();
            State rootState = items[0].getState();
            vItems[0] = new HistViewItem(0, activeItem, rootState, null, cs);
            int i = 1;
            while (i < size) {
                State state = items[i].getState();
                Operation op = items[i - 1].getOperation();
                vItems[i] = new HistViewItem(i, activeItem, state, op, cs);
                ++i;
            }
            current = vItems[activeItem];
            Collections.reverse(Arrays.asList(vItems));
        } else {
            current = null;
        }
        this.tableViewer.setInput((Object)vItems);
        this.tableViewer.refresh();
        if (current != null) {
            this.tableViewer.reveal(current);
        }
    }

    public void setShowParameters(boolean show) {
        if (this.labelProviders != null) {
            for (HistoryLabelProvider provider : this.labelProviders) {
                provider.setShowParameters(show);
            }
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                HistoryView.this.tableViewer.refresh();
            }
        };
        Display.getDefault().asyncExec(runnable);
    }

    private static class HistContentProvider
    implements IStructuredContentProvider {
        private HistContentProvider() {
        }

        public Object[] getElements(Object data) {
            return data == null ? new HistViewItem[]{} : (HistViewItem[])data;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    private static class HistDoubleClickListener
    implements IDoubleClickListener {
        private static final String EXCEPTION_MSG = "exception raised while trying to jump to state";

        private HistDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            if (sel != null && !sel.isEmpty()) {
                HistViewItem item = (HistViewItem)sel.getFirstElement();
                try {
                    item.jumpToState();
                }
                catch (ProBException e) {
                    Logger.notifyUser((String)EXCEPTION_MSG, (Throwable)e);
                }
            }
        }
    }

    static class HistViewItem {
        private final int historyPosition;
        private final int activePosition;
        private final State dstState;
        private final Operation operation;
        private final boolean previousStateIsSameAsCurrent;
        private final boolean followingStateIsSameAsCurrent;

        public HistViewItem(int historyPosition, int activePosition, State dstState, Operation operation, State currentState) {
            this.historyPosition = historyPosition;
            this.activePosition = activePosition;
            this.dstState = dstState;
            this.operation = operation;
            this.previousStateIsSameAsCurrent = operation != null && Objects.equals(currentState.getId(), operation.getSource());
            this.followingStateIsSameAsCurrent = Objects.equals(currentState, dstState);
        }

        public State getDestination() {
            return this.dstState;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public boolean followingStateIsActive() {
            return this.activePosition == this.historyPosition;
        }

        public boolean previousStateIsActive() {
            return this.activePosition == this.historyPosition - 1;
        }

        public boolean followingStateIsSameAsCurrent() {
            return this.followingStateIsSameAsCurrent;
        }

        public boolean previousStateIsSameAsCurrent() {
            return this.previousStateIsSameAsCurrent;
        }

        public void jumpToState() throws ProBException {
            History history = Animator.getAnimator().getHistory();
            history.gotoPos(this.historyPosition);
        }
    }
}

