/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.historyview;

import de.prob.core.domainobjects.Operation;
import de.prob.ui.historyview.HistoryLabelProvider;
import de.prob.ui.historyview.HistoryView;
import de.prob.ui.historyview.HistoryViewStrings;
import java.util.Collection;
import java.util.List;

class HistoryEventLabelProvider
extends HistoryLabelProvider {
    private final int eventStackPosition;

    public HistoryEventLabelProvider(int eventStackPosition) {
        this.eventStackPosition = eventStackPosition;
    }

    @Override
    protected String getText(HistoryView.HistViewItem item) {
        String result;
        Operation operation = item.getOperation();
        if (operation != null) {
            List stack = operation.getEventStack();
            if (stack != null) {
                if (this.eventStackPosition < stack.size()) {
                    Operation.EventStackElement stackElem = (Operation.EventStackElement)stack.get(this.eventStackPosition);
                    result = this.printEventWithParameters(stackElem.getEventName(), stackElem.getParameters());
                } else {
                    result = null;
                }
            } else {
                result = this.eventStackPosition == 0 ? this.printEventWithParameters(operation.getName(), operation.getArguments()) : null;
            }
        } else {
            result = this.eventStackPosition == 0 ? HistoryViewStrings.uninitialisedState : null;
        }
        return result == null ? "" : result;
    }

    private String printEventWithParameters(String name, Collection<String> parameters) {
        String result;
        if (!this.showParameters || parameters.isEmpty()) {
            result = name;
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(name);
            sb.append('(');
            boolean isFirst = true;
            for (String param : parameters) {
                if (!isFirst) {
                    sb.append(',');
                }
                sb.append(param);
                isFirst = false;
            }
            sb.append(')');
            result = sb.toString();
        }
        return result;
    }
}

