/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.assertion;

import de.prob.core.Animator;
import de.prob.core.ProBJobFinishedListener;
import de.prob.core.command.ConstraintBasedAssertionCheckCommand;
import de.prob.core.command.ExecuteOperationCommand;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class AssertionCheckFinishedListener
extends ProBJobFinishedListener {
    private final Shell shell;

    public AssertionCheckFinishedListener(Shell shell) {
        this.shell = shell;
    }

    protected void showResult(IComposableCommand cmd, Animator animator) {
        String message;
        String dialogTitle;
        int dialogType;
        ConstraintBasedAssertionCheckCommand command = (ConstraintBasedAssertionCheckCommand)cmd;
        ConstraintBasedAssertionCheckCommand.ResultType result = command.getResult();
        if (result == null) {
            dialogType = 1;
            dialogTitle = "Errow During Constraint Based Check";
            message = "ProB did not return a result";
        } else {
            switch (result) {
                case NO_COUNTER_EXAMPLE_EXISTS: {
                    dialogType = 2;
                    dialogTitle = "No Counter-Example Exists";
                    message = "No Counter-Example to the Context Theorems exists (for current settings of deferred sets).\nIf your model contains deferred sets, there may exist counter-examples for other sizes of these sets.";
                    break;
                }
                case NO_COUNTER_EXAMPLE_FOUND: {
                    dialogType = 2;
                    dialogTitle = "No Counter-Example Found";
                    message = "No Counter-Example to the Context Theorems was found (but one may exist).";
                    break;
                }
                case COUNTER_EXAMPLE: {
                    dialogType = 4;
                    dialogTitle = "COUNTER-EXAMPLE FOUND!";
                    message = "A counter-example to the context theorems was found: it will be shown in the state view.\nThis counter-example state satisfies the axioms but not all theorems.";
                    this.displayCounterExample(command, animator);
                    break;
                }
                case INTERRUPTED: {
                    dialogType = 4;
                    dialogTitle = " Interrupt";
                    message = "The context theorem check has been interrupted by the user or a time-out.";
                    break;
                }
                default: {
                    Logger.notifyUser((String)("Unexpected result: " + String.valueOf(result)));
                    return;
                }
            }
        }
        if (this.shell.isDisposed()) {
            System.out.println("Context Theorems check finished: " + dialogTitle);
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    MessageDialog.open((int)dialogType, (Shell)AssertionCheckFinishedListener.this.shell, (String)dialogTitle, (String)message, (int)0);
                }
            };
            this.shell.getDisplay().asyncExec(runnable);
        }
    }

    private void displayCounterExample(ConstraintBasedAssertionCheckCommand command, Animator animator) {
        Operation operation = command.getCounterExampleOperation();
        try {
            animator.getHistory().gotoPos(0);
            ExecuteOperationCommand.executeOperation((Animator)animator, (Operation)operation);
        }
        catch (ProBException e) {
            e.notifyUserOnce();
        }
    }
}

