/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.stateview;

import de.prob.core.domainobjects.State;
import de.prob.ui.ProbUiPlugin;
import de.prob.ui.stateview.StateLabelProvider;
import de.prob.ui.stateview.statetree.StaticStateElement;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class VarLabelProvider
extends BaseLabelProvider
implements ITableLabelProvider,
ITableColorProvider,
ITableFontProvider {
    private static final String RODIN_FONT_KEY = "org.rodinp.keyboard.textFont";
    private final StateLabelProvider slProvider = new StateLabelProvider();
    private final Color gray = Display.getCurrent().getSystemColor(15);
    private State currentState;
    private State lastState;

    public void setStates(State currentState, State lastState) {
        this.currentState = currentState;
        this.lastState = lastState;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        State state;
        Image image = this.isApplicable(element) ? (columnIndex == 0 ? (this.hasChanged(element) ? ProbUiPlugin.getDefault().getImageRegistry().get("change_star") : null) : ((state = this.getState(columnIndex)) == null ? null : this.slProvider.getImage(state, (StaticStateElement)element))) : null;
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        String result;
        if (this.isApplicable(element)) {
            State state;
            StaticStateElement sse = (StaticStateElement)element;
            result = columnIndex == 0 ? sse.getLabel() : ((state = this.getState(columnIndex)) == null ? null : this.slProvider.getText(state, sse));
        } else {
            result = null;
        }
        return result;
    }

    public Color getBackground(Object element, int column) {
        State state;
        Color color = this.isApplicable(element) ? ((state = this.getState(column)) == null ? null : this.slProvider.getBackground(state, (StaticStateElement)element)) : null;
        return color;
    }

    public Color getForeground(Object element, int column) {
        Color color;
        if (this.isApplicable(element)) {
            State curState = this.getState(column == 0 ? 1 : column);
            boolean changed = this.hasChanged(element);
            color = curState == null ? this.gray : this.slProvider.getForeground(curState, changed, (StaticStateElement)element);
        } else {
            color = null;
        }
        return color;
    }

    public Font getFont(Object element, int column) {
        FontRegistry fontRegistry = JFaceResources.getFontRegistry();
        Font font = this.isApplicable(element) && this.hasChanged(element) ? fontRegistry.getBold(RODIN_FONT_KEY) : fontRegistry.get(RODIN_FONT_KEY);
        return font;
    }

    private boolean hasChanged(Object element) {
        return ((StaticStateElement)element).hasChanged(this.currentState, this.lastState);
    }

    private boolean isApplicable(Object element) {
        return element != null && element instanceof StaticStateElement;
    }

    private State getState(int column) {
        State state;
        switch (column) {
            case 1: {
                state = this.currentState;
                break;
            }
            case 2: {
                state = this.lastState;
                break;
            }
            default: {
                state = null;
            }
        }
        return state;
    }
}

