/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.stateview;

import de.prob.core.Animator;
import de.prob.core.LanguageDependendAnimationPart;
import de.prob.core.LimitedLogger;
import de.prob.core.command.EvaluationGetTopLevelCommand;
import de.prob.core.command.EvaluationGetValuesCommand;
import de.prob.core.domainobjects.EvaluationElement;
import de.prob.core.domainobjects.MachineDescription;
import de.prob.core.domainobjects.Operation;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import de.prob.ui.StateBasedViewPart;
import de.prob.ui.dnd.StaticStateElementTransfer;
import de.prob.ui.stateview.BooleanLabelProvider;
import de.prob.ui.stateview.LabelViewer;
import de.prob.ui.stateview.ShownState;
import de.prob.ui.stateview.SimpleContentProvider;
import de.prob.ui.stateview.StateViewStrings;
import de.prob.ui.stateview.ToggleShowDuplicatesHandler;
import de.prob.ui.stateview.VarContentProvider;
import de.prob.ui.stateview.VarLabelProvider;
import de.prob.ui.stateview.statetree.StateTreeElement;
import de.prob.ui.stateview.statetree.StateTreeExpression;
import de.prob.ui.stateview.statetree.StateTreeExpressionSection;
import de.prob.ui.stateview.statetree.StateTreeSection;
import de.prob.ui.stateview.statetree.StateTreeVariable;
import de.prob.ui.stateview.statetree.StaticStateElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.commands.State;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;

public class StateViewPart
extends StateBasedViewPart {
    public static final String STATE_VIEW_ID = "de.prob.ui.StateView";
    private static final ShowMultipleVarsFilter DUP_FILTER = new ShowMultipleVarsFilter();
    private Composite pageComposite;
    private TreeViewer treeViewer;
    private LabelViewer invariantViewer;
    private LabelViewer stateErrorViewer;
    private LabelViewer timeoutViewer;
    private ShownState shownState;
    private LabelViewer modelchangeViewer;
    private Collection<EvaluationElement> topEvaluationElements;
    private StateTreeExpressionSection expressionSection;
    private final VarLabelProvider varLabelProvider = new VarLabelProvider();

    @Override
    public Control createStatePartControl(Composite parent) {
        this.pageComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        this.pageComposite.setLayout((Layout)layout);
        this.createVariableTree();
        this.createSignalLabels();
        this.pageComposite.pack();
        this.hookContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.initDragAndDrop();
        this.initialiseFilter();
        return this.pageComposite;
    }

    private void initialiseFilter() {
        State filterState = ToggleShowDuplicatesHandler.getCurrentState((IServiceLocator)this.getSite());
        this.setDuplicateVariableFilter((Boolean)filterState.getValue());
    }

    private void hookContextMenu() {
        final StateViewPart x = this;
        TreeViewer viewer = this.treeViewer;
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                x.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void initDragAndDrop() {
        Transfer[] transferTypes = new Transfer[]{StaticStateElementTransfer.getInstance(), TextTransfer.getInstance()};
        this.treeViewer.addDragSupport(1, transferTypes, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)StateViewPart.this.treeViewer.getSelection();
                StaticStateElement[] elements = new StaticStateElement[selection.size()];
                int i = 0;
                Iterator it = selection.iterator();
                while (it.hasNext()) {
                    elements[i] = (StaticStateElement)it.next();
                    ++i;
                }
                if (StaticStateElementTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = elements;
                } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    StringBuilder sb = new StringBuilder();
                    boolean first = true;
                    StaticStateElement[] staticStateElementArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StaticStateElement element = staticStateElementArray[n2];
                        if (!first) {
                            sb.append(", ");
                            first = false;
                        }
                        sb.append(element.getLabel());
                        ++n2;
                    }
                    event.data = sb.toString();
                }
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
    }

    @Override
    protected void stateChanged(de.prob.core.domainobjects.State activeState, Operation operation) {
        LimitedLogger.getLogger().log("state view: new state", activeState == null ? null : activeState.getId(), null);
        this.initShownState();
        Animator animator = Animator.getAnimator();
        de.prob.core.domainobjects.State lastState = animator.getHistory().getState(-1);
        this.shownState.setCurrent(activeState);
        this.shownState.setLast(lastState);
        this.loadEvaluationElements(this.shownState, activeState, lastState);
        this.varLabelProvider.setStates(activeState, lastState);
        this.treeViewer.refresh(true);
        this.invariantViewer.setInput(activeState);
        this.stateErrorViewer.setInput(activeState);
        this.timeoutViewer.setInput(activeState);
        this.modelchangeViewer.setInput(activeState);
    }

    private void loadEvaluationElements(ShownState shownState, de.prob.core.domainobjects.State current, de.prob.core.domainobjects.State last) {
        block4: {
            HashSet<EvaluationElement> visibleElements = new HashSet<EvaluationElement>();
            boolean errorShown = false;
            visibleElements.addAll(this.topEvaluationElements);
            try {
                Object[] objectArray = this.treeViewer.getVisibleExpandedElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof StateTreeExpression) {
                        StateTreeExpression ste = (StateTreeExpression)obj;
                        EvaluationElement elem = ste.getStaticElement();
                        visibleElements.add(elem);
                        visibleElements.addAll(Arrays.asList(elem.getChildren()));
                    }
                    ++n2;
                }
                EvaluationGetValuesCommand.getValuesForExpressionsCached((de.prob.core.domainobjects.State)current, visibleElements);
                EvaluationGetValuesCommand.getValuesForExpressionsCached((de.prob.core.domainobjects.State)last, visibleElements);
            }
            catch (ProBException e) {
                if (errorShown) break block4;
                e.notifyUserOnce();
            }
        }
    }

    @Override
    protected void stateReset() {
        this.shownState = null;
        this.varLabelProvider.setStates(null, null);
    }

    private void initShownState() {
        if (this.shownState == null) {
            try {
                EvaluationElement[] tops = EvaluationGetTopLevelCommand.retrieveTopLevelElements();
                this.topEvaluationElements = new ArrayList<EvaluationElement>(Arrays.asList(tops));
            }
            catch (ProBException e) {
                e.notifyUserOnce();
                this.topEvaluationElements = Collections.emptyList();
            }
            this.shownState = new ShownState();
            MachineDescription md = Animator.getAnimator().getMachineDescription();
            this.shownState.setMachineDescription(md);
            StateTreeElement[] topLevelElements = new StateTreeElement[this.shownState.getSections().size() + 1];
            int i = 0;
            for (String section : this.shownState.getSections()) {
                topLevelElements[i] = new StateTreeSection(section, md);
                ++i;
            }
            this.expressionSection = new StateTreeExpressionSection(StateViewStrings.formulasSectionLabel, this.topEvaluationElements);
            topLevelElements[i] = this.expressionSection;
            this.treeViewer.setInput((Object)topLevelElements);
        }
    }

    private void createSignalLabels() {
        GridData signalLayout = new GridData();
        signalLayout.horizontalAlignment = 4;
        Display display = Display.getCurrent();
        Color gray = display.getSystemColor(15);
        Color orange = display.getSystemColor(8);
        Color yellow = display.getSystemColor(7);
        Color green = display.getSystemColor(5);
        Color red = display.getSystemColor(3);
        Font bold = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.bannerfont");
        this.invariantViewer = new LabelViewer(this.pageComposite, 0);
        this.invariantViewer.getLabel().setLayoutData((Object)signalLayout);
        this.invariantViewer.getLabel().setToolTipText(StateViewStrings.signalInvariantTooltip);
        BooleanLabelProvider invProvider = new BooleanLabelProvider();
        invProvider.setTexts(null, StateViewStrings.signalInvariantGood, StateViewStrings.signalInvariantBad);
        invProvider.setBackgroundColors(gray, green, red);
        invProvider.setFonts(null, null, bold);
        this.invariantViewer.setLabelProvider(invProvider);
        this.invariantViewer.setContentProvider(new InvContentProvider());
        this.stateErrorViewer = new LabelViewer(this.pageComposite, 0);
        this.stateErrorViewer.getLabel().setLayoutData((Object)signalLayout);
        this.stateErrorViewer.getLabel().setToolTipText(StateViewStrings.signalEventerrorTooltip);
        BooleanLabelProvider errorProvider = new BooleanLabelProvider();
        errorProvider.setTexts(null, StateViewStrings.signalEventerrorGood, StateViewStrings.signalEventerrorBad);
        errorProvider.setBackgroundColors(gray, green, red);
        errorProvider.setFonts(null, null, null);
        this.stateErrorViewer.setLabelProvider(errorProvider);
        this.stateErrorViewer.setContentProvider(new StateErrorProvider());
        this.stateErrorViewer.addMouseListener(new ErrorViewDoubleClick());
        this.modelchangeViewer = new LabelViewer(this.pageComposite, 0);
        this.modelchangeViewer.getLabel().setLayoutData((Object)signalLayout);
        this.modelchangeViewer.getLabel().setToolTipText(StateViewStrings.signalModelmodifiedTooltip);
        this.modelchangeViewer.addMouseListener(new ResetAnimationListener());
        BooleanLabelProvider modelchangeProvider = new BooleanLabelProvider();
        modelchangeProvider.setTexts(null, StateViewStrings.signalModelhasRodinErrors, StateViewStrings.signalModelmodifiedBad);
        modelchangeProvider.setBackgroundColors(gray, yellow, red);
        modelchangeProvider.setFonts(null, bold, bold);
        modelchangeProvider.hideWhenInactive(false);
        this.modelchangeViewer.setLabelProvider(modelchangeProvider);
        this.modelchangeViewer.setContentProvider(new ModelChangeContentProvider());
        this.timeoutViewer = new LabelViewer(this.pageComposite, 0);
        this.timeoutViewer.getLabel().setLayoutData((Object)signalLayout);
        this.timeoutViewer.getLabel().setToolTipText(StateViewStrings.signalTimeoutTooltip);
        BooleanLabelProvider timeoutProvider = new BooleanLabelProvider();
        timeoutProvider.setTexts(null, StateViewStrings.signalTimeoutMaxReached, StateViewStrings.signalTimeoutBad);
        timeoutProvider.setBackgroundColors(gray, orange, red);
        timeoutProvider.setFonts(null, bold, bold);
        timeoutProvider.hideWhenInactive(false);
        this.timeoutViewer.setLabelProvider(timeoutProvider);
        this.timeoutViewer.setContentProvider(new TimeoutContentProvider());
    }

    private void createVariableTree() {
        GridData treeViewerLayout = new GridData();
        treeViewerLayout.grabExcessHorizontalSpace = true;
        treeViewerLayout.grabExcessVerticalSpace = true;
        treeViewerLayout.horizontalAlignment = 4;
        treeViewerLayout.verticalAlignment = 4;
        treeViewerLayout.horizontalSpan = 2;
        this.treeViewer = new TreeViewer(this.pageComposite);
        this.treeViewer.getTree().setLayoutData((Object)treeViewerLayout);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.setAutoExpandLevel(2);
        TreeViewerColumn col1 = new TreeViewerColumn(this.treeViewer, 16384);
        col1.getColumn().setText(StateViewStrings.columnHeaderName);
        col1.getColumn().setResizable(true);
        col1.getColumn().setWidth(200);
        TreeViewerColumn col2 = new TreeViewerColumn(this.treeViewer, 131072);
        col2.getColumn().setText(StateViewStrings.columnHeaderCurrentvalue);
        col2.getColumn().setResizable(true);
        col2.getColumn().setWidth(150);
        TreeViewerColumn col3 = new TreeViewerColumn(this.treeViewer, 131072);
        col3.getColumn().setText(StateViewStrings.columnHeaderPreviousvalue);
        col3.getColumn().setResizable(true);
        col3.getColumn().setWidth(150);
        this.treeViewer.setContentProvider((IContentProvider)new VarContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.varLabelProvider);
        this.treeViewer.setInput(null);
        this.treeViewer.getTree().addListener(41, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                Font fontOfFirstColumn = item.getFont(1);
                FontData fd = fontOfFirstColumn.getFontData()[0];
                if ((fd.getStyle() & 1) != 0) {
                    event.height = fd.getHeight() + 8;
                }
            }
        });
    }

    public void setDuplicateVariableFilter(boolean filterState) {
        ViewerFilter[] viewerFilterArray;
        if (filterState) {
            ViewerFilter[] viewerFilterArray2 = new ViewerFilter[1];
            viewerFilterArray = viewerFilterArray2;
            viewerFilterArray2[0] = DUP_FILTER;
        } else {
            viewerFilterArray = new ViewerFilter[]{};
        }
        ViewerFilter[] filters = viewerFilterArray;
        this.treeViewer.setFilters(filters);
        this.refreshTreeView();
    }

    private void refreshTreeView() {
        Runnable refresh = new Runnable(){

            @Override
            public void run() {
                StateViewPart.this.treeViewer.refresh();
            }
        };
        Display.getDefault().asyncExec(refresh);
    }

    public void addUserDefinedExpression(EvaluationElement userDefinedElement) {
        this.expressionSection.addChild(userDefinedElement);
        this.topEvaluationElements.add(userDefinedElement);
        this.refreshTreeView();
    }

    private static class ErrorViewDoubleClick
    implements MouseListener {
        private ErrorViewDoubleClick() {
        }

        public void mouseDoubleClick(MouseEvent event) {
            IWorkbenchPage wpage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                wpage.showView("de.prob.ui.EventErrorView");
            }
            catch (PartInitException e) {
                Logger.notifyUser((String)StateViewStrings.errorShowEventerrors, (Throwable)e);
            }
        }

        public void mouseDown(MouseEvent arg0) {
        }

        public void mouseUp(MouseEvent arg0) {
        }
    }

    private static class InvContentProvider
    extends SimpleContentProvider {
        private InvContentProvider() {
        }

        @Override
        public Object convert(Object element) {
            de.prob.core.domainobjects.State state;
            Boolean result = element != null && element instanceof de.prob.core.domainobjects.State ? ((state = (de.prob.core.domainobjects.State)element).isInitialized() ? Boolean.valueOf(state.isInvariantPreserved()) : null) : null;
            return result;
        }
    }

    private static class ModelChangeContentProvider
    extends SimpleContentProvider {
        private ModelChangeContentProvider() {
        }

        @Override
        public Object convert(Object element) {
            if (Animator.getAnimator().isDirty()) {
                return false;
            }
            if (Animator.getAnimator().isRodinProjectHasErrorsOrWarnings()) {
                return true;
            }
            return null;
        }
    }

    private static class ResetAnimationListener
    implements MouseListener {
        private ResetAnimationListener() {
        }

        public void mouseDoubleClick(MouseEvent event) {
            Animator animator = Animator.getAnimator();
            LanguageDependendAnimationPart ldp = animator.getLanguageDependendPart();
            if (ldp != null) {
                try {
                    ldp.reload(animator);
                }
                catch (ProBException e) {
                    e.notifyUserOnce();
                }
            }
        }

        public void mouseDown(MouseEvent arg0) {
        }

        public void mouseUp(MouseEvent arg0) {
        }
    }

    private static class ShowMultipleVarsFilter
    extends ViewerFilter {
        private ShowMultipleVarsFilter() {
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            if (element instanceof StateTreeSection) {
                return ((StateTreeSection)element).isMainSectionOfVariable();
            }
            if (element instanceof StateTreeVariable) {
                return ((StateTreeVariable)element).isInMainSection();
            }
            return true;
        }
    }

    private static class StateErrorProvider
    extends SimpleContentProvider {
        private StateErrorProvider() {
        }

        @Override
        public Object convert(Object element) {
            de.prob.core.domainobjects.State state;
            Boolean result = element != null && element instanceof de.prob.core.domainobjects.State ? Boolean.valueOf(!(state = (de.prob.core.domainobjects.State)element).hasStateBasedErrors()) : null;
            return result;
        }
    }

    private static class TimeoutContentProvider
    extends SimpleContentProvider {
        private TimeoutContentProvider() {
        }

        @Override
        public Object convert(Object element) {
            de.prob.core.domainobjects.State state;
            Boolean result = element != null && element instanceof de.prob.core.domainobjects.State ? ((state = (de.prob.core.domainobjects.State)element).isTimeoutOccured() ? Boolean.FALSE : (state.isMaxOperationReached() ? Boolean.TRUE : null)) : null;
            return result;
        }
    }
}

