/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.stateview;

import de.prob.core.Animator;
import de.prob.core.command.ExploreStateCommand;
import de.prob.core.command.GetFullTraceCommand;
import de.prob.core.command.SetStateCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import de.prob.exceptions.ProBException;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;

public class LoadShortestTraceHandler
extends AbstractHandler
implements IHandler {
    private List<String> states;
    private final Animator animator = Animator.getAnimator();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String stateId = this.animator.getCurrentState().getId();
        try {
            SetStateCommand.setState((Animator)this.animator, (String)stateId);
        }
        catch (ProBException proBException) {
            return null;
        }
        this.loadTrace();
        try {
            this.animator.getHistory().gotoPos(0);
        }
        catch (ProBException proBException) {
            return null;
        }
        State state = this.animator.getCurrentState();
        try {
            for (String nextState : this.states) {
                Operation op = this.getOperationByDstId(nextState, state.getEnabledOperations());
                state = ExploreStateCommand.exploreState((Animator)this.animator, (String)nextState);
                this.animator.getHistory().add(state, op);
                this.animator.announceCurrentStateChanged(state, op);
            }
        }
        catch (ProBException e) {
            e.notifyUserOnce();
        }
        return null;
    }

    private void loadTrace() {
        try {
            this.states = GetFullTraceCommand.getTrace((Animator)this.animator).getStates();
        }
        catch (ProBException e) {
            ((Object)((Object)e)).notify();
            return;
        }
    }

    private Operation getOperationByDstId(String dstId, List<Operation> operations) {
        for (Operation op : operations) {
            if (!op.getDestination().equals(dstId)) continue;
            return op;
        }
        return null;
    }
}

