/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.stateview;

import de.prob.ui.stateview.IVisibilityProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class BooleanLabelProvider
extends BaseLabelProvider
implements ILabelProvider,
IColorProvider,
IFontProvider,
IVisibilityProvider {
    private static int INACTIVE = 0;
    private static int OK = 1;
    private static int KO = 2;
    private final Color[] foregroundColors = new Color[3];
    private final Color[] backgroundColors = new Color[3];
    private final String[] texts = new String[3];
    private final Image[] images = new Image[3];
    private final Font[] fonts = new Font[3];
    private boolean hideInactive = false;

    private static int toState(Object element) {
        int state = element != null && element instanceof Boolean ? ((Boolean)element != false ? OK : KO) : INACTIVE;
        return state;
    }

    public Color getBackground(Object element) {
        return this.backgroundColors[BooleanLabelProvider.toState(element)];
    }

    public Color getForeground(Object element) {
        return this.foregroundColors[BooleanLabelProvider.toState(element)];
    }

    public Image getImage(Object element) {
        return this.images[BooleanLabelProvider.toState(element)];
    }

    public String getText(Object element) {
        return this.texts[BooleanLabelProvider.toState(element)];
    }

    public Font getFont(Object element) {
        return this.fonts[BooleanLabelProvider.toState(element)];
    }

    @Override
    public boolean isVisible(Object element) {
        return !this.hideInactive || BooleanLabelProvider.toState(element) != INACTIVE;
    }

    public void setTexts(String inactive, String ok, String ko) {
        this.texts[BooleanLabelProvider.INACTIVE] = inactive;
        this.texts[BooleanLabelProvider.OK] = ok;
        this.texts[BooleanLabelProvider.KO] = ko;
        this.fireChangedEvent();
    }

    public void setImages(Image inactive, Image ok, Image ko) {
        this.images[BooleanLabelProvider.INACTIVE] = inactive;
        this.images[BooleanLabelProvider.OK] = ok;
        this.images[BooleanLabelProvider.KO] = ko;
        this.fireChangedEvent();
    }

    public void setForegroundColors(Color inactive, Color ok, Color ko) {
        this.foregroundColors[BooleanLabelProvider.INACTIVE] = inactive;
        this.foregroundColors[BooleanLabelProvider.OK] = ok;
        this.foregroundColors[BooleanLabelProvider.KO] = ko;
        this.fireChangedEvent();
    }

    public void setBackgroundColors(Color inactive, Color ok, Color ko) {
        this.backgroundColors[BooleanLabelProvider.INACTIVE] = inactive;
        this.backgroundColors[BooleanLabelProvider.OK] = ok;
        this.backgroundColors[BooleanLabelProvider.KO] = ko;
        this.fireChangedEvent();
    }

    public void setFonts(Font inactive, Font ok, Font ko) {
        this.fonts[BooleanLabelProvider.INACTIVE] = inactive;
        this.fonts[BooleanLabelProvider.OK] = ok;
        this.fonts[BooleanLabelProvider.KO] = ko;
        this.fireChangedEvent();
    }

    public void hideWhenInactive(boolean hide) {
        this.hideInactive = hide;
    }

    private void fireChangedEvent() {
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
    }
}

