/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.operationview;

import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.prob.core.Animator;
import de.prob.core.command.ExecuteOperationCommand;
import de.prob.core.command.GetOperationNamesCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.OperationInfo;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import de.prob.ui.operationview.EventBInputValidator;
import de.prob.ui.operationview.GetOperationByPredicateCommand2;
import de.prob.unicode.UnicodeTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;

public class CustomPreconditionInputDialog
extends InputDialog {
    private final Animator animator;
    private final Operation op;

    public CustomPreconditionInputDialog(Shell parentShell, Operation op, Animator a) {
        super(parentShell, "Execute with additional Guard Constraint", CustomPreconditionInputDialog.getMenuText(op, a), CustomPreconditionInputDialog.getDefaultPredicate(op, a), (IInputValidator)new EventBInputValidator());
        this.op = op;
        this.animator = a;
    }

    private static String getMenuText(Operation op, Animator animator) {
        StringBuffer sb = new StringBuffer();
        sb.append("Enter Guard Constraint to be added to the Event \"");
        sb.append(op.getName());
        sb.append("\" before execution.");
        List<String> params = CustomPreconditionInputDialog.getOperationParams(op, animator);
        if (params.size() > 0) {
            sb.append("\nParameters are:");
            for (String arg : params) {
                sb.append(" ");
                sb.append(arg);
            }
        }
        return sb.toString();
    }

    private static String getDefaultPredicate(Operation op, Animator animator) {
        StringBuffer sb = new StringBuffer();
        List<String> params = CustomPreconditionInputDialog.getOperationParams(op, animator);
        List vals = op.getArguments();
        int sze = Math.min(params.size(), vals.size());
        int i = 0;
        while (i < sze) {
            sb.append(params.get(i));
            sb.append(" = ");
            sb.append((String)vals.get(i));
            if (i != sze - 1) {
                sb.append(" & ");
            }
            ++i;
        }
        return sb.toString();
    }

    private Operation getCustomOperation() {
        try {
            Operation customOp = GetOperationByPredicateCommand2.getOperation(this.animator, this.op.getSource(), Operation.getInternalName((String)this.op.getName()), UnicodeTranslator.toUnicode((String)this.getValue()));
            if (customOp == null) {
                Logger.notifyUser((String)("Could not execute the event " + this.op.getName() + " with the additional predicate provided!"));
            } else {
                ExecuteOperationCommand.executeOperation((Animator)this.animator, (Operation)customOp);
            }
        }
        catch (ProBException e) {
            e.printStackTrace();
        }
        catch (BCompoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Operation getOperation(Operation op) {
        CustomPreconditionInputDialog osd = new CustomPreconditionInputDialog(new Shell(), op, Animator.getAnimator());
        if (osd.open() == 0) {
            return osd.getCustomOperation();
        }
        return null;
    }

    private static List<String> getOperationParams(Operation op, Animator animator) {
        ArrayList<String> result;
        OperationInfo params;
        List infos = null;
        try {
            infos = GetOperationNamesCommand.getNames((Animator)animator);
        }
        catch (ProBException e) {
            e.notifyUserOnce();
        }
        OperationInfo operationInfo = params = infos == null ? null : OperationInfo.getParams((String)op.getName(), (Collection)infos);
        if (params != null) {
            result = params.getParameters();
        } else {
            int numArgs = op.getArguments().size();
            result = new ArrayList<String>(numArgs);
            int i = 0;
            while (i < numArgs) {
                result.add("");
                ++i;
            }
        }
        return result;
    }
}

