/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.ltl.handler;

import de.prob.core.Animator;
import de.prob.ui.PerspectiveFactory;
import de.prob.ui.ltl.LtlCheckingDialog;
import de.prob.ui.services.ModelLoadedProvider;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.services.ISourceProviderService;

public final class LtlCommand
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        Shell shell = window.getShell();
        if (!this.isEnabled(window)) {
            ErrorDialog.openError((Shell)shell, (String)"Error", (String)"Please start an animation first", (IStatus)new Status(4, "de.prob.ui", "Please start an animation first", null));
            return null;
        }
        PerspectiveFactory.openPerspective();
        Animator animator = Animator.getAnimator();
        if (!animator.isRunning()) {
            return null;
        }
        LtlCheckingDialog md = new LtlCheckingDialog(shell);
        md.setBlockOnOpen(true);
        md.open();
        return null;
    }

    private boolean isEnabled(IWorkbenchWindow window) {
        ISourceProviderService service = (ISourceProviderService)window.getService(ISourceProviderService.class);
        ModelLoadedProvider sourceProvider = (ModelLoadedProvider)service.getSourceProvider("de.prob.core.model_loaded");
        return sourceProvider.isEnabled();
    }
}

