/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.ltl;

import de.prob.core.Animator;
import de.prob.core.command.LtlCheckingCommand;
import de.prob.core.command.SetPreferenceCommand;
import de.prob.exceptions.ProBException;
import de.prob.prolog.term.PrologTerm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public final class LtlCheckingJob
extends Job {
    private final Animator animator = Animator.getAnimator();
    private final PrologTerm formula;
    private final LtlCheckingCommand.StartMode option;
    private final String symmetry;
    private boolean abort = false;
    private LtlCheckingCommand.Result modelCheckingResult;
    private boolean anErrorOccurred = false;

    public LtlCheckingJob(String name, PrologTerm parsedFormula, LtlCheckingCommand.StartMode option, String symmetry) {
        super(name);
        this.formula = parsedFormula;
        this.option = option;
        this.symmetry = symmetry;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.anErrorOccurred = false;
        if (!this.setSymmetry()) {
            return Status.CANCEL_STATUS;
        }
        monitor.beginTask("Checking LTL Formula", -1);
        while (!this.abort) {
            try {
                this.modelCheckingResult = this.doSomeModelchecking();
                monitor.worked(500);
            }
            catch (ProBException e) {
                e.notifyUserOnce();
                this.anErrorOccurred = true;
                return Status.CANCEL_STATUS;
            }
            boolean bl = this.abort = this.modelCheckingResult.isAbort() || monitor.isCanceled();
        }
        return Status.OK_STATUS;
    }

    public LtlCheckingCommand.Result getModelCheckingResult() {
        return this.modelCheckingResult;
    }

    public boolean isAnErrorOccurred() {
        return this.anErrorOccurred;
    }

    private LtlCheckingCommand.Result doSomeModelchecking() throws ProBException {
        return LtlCheckingCommand.modelCheck((Animator)this.animator, (PrologTerm)this.formula, (int)-1, (LtlCheckingCommand.StartMode)this.option);
    }

    private boolean setSymmetry() {
        try {
            SetPreferenceCommand.setPreference((Animator)this.animator, (String)"SYMMETRY_MODE", (String)this.symmetry);
        }
        catch (ProBException proBException) {
            return false;
        }
        return true;
    }
}

