/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.ltl;

import de.prob.core.Animator;
import de.prob.core.command.LtlCheckingCommand;
import de.prob.core.domainobjects.History;
import de.prob.core.domainobjects.HistoryItem;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.core.domainobjects.ltl.CounterExampleProposition;
import de.prob.core.domainobjects.ltl.CounterExampleState;
import de.prob.logging.Logger;
import de.prob.ui.ltl.CounterExampleContentProvider;
import de.prob.ui.ltl.CounterExampleEditPartFactory;
import de.prob.ui.ltl.CounterExampleTableMouseAdapter;
import de.prob.ui.ltl.CounterExampleTableViewer;
import de.prob.ui.ltl.CounterExampleTreeMouseAdapter;
import de.prob.ui.ltl.CounterExampleTreeViewer;
import de.prob.ui.ltl.CounterExampleViewPart;
import de.prob.ui.ltl.TableColumnEventLabelProvider;
import de.prob.ui.ltl.TableColumnValueLabelProvider;
import de.prob.ui.ltl.TreeColumnPropositionLabelProvider;
import de.prob.ui.ltl.TreeColumnValueLabelProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.print.PrintGraphicalViewerOperation;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class CounterExampleTab {
    private final CounterExample counterExample;
    private final CTabItem tabItem;
    private final StackLayout layout;
    private final TableViewer tableViewer;
    private final TreeViewer treeViewer;
    private final ScalableRootEditPart rootEditPart;
    private final GraphicalViewer graphicalViewer;
    private final Control interactiveView;
    private int currentIndex = -1;

    public CounterExampleTab(CTabFolder tabFolder, CounterExample counterExample) {
        this.counterExample = counterExample;
        this.tabItem = new CTabItem(tabFolder, 64);
        this.tabItem.setText(counterExample.getPropositionRoot().toString());
        SashForm sashForm = new SashForm((Composite)tabFolder, 256);
        this.tabItem.setControl((Control)sashForm);
        Composite composite = new Composite((Composite)sashForm, 0);
        this.layout = new StackLayout();
        composite.setLayout((Layout)this.layout);
        Composite tableView = new Composite(composite, 0);
        this.tableViewer = this.createTableViewer(tableView, counterExample);
        Composite treeView = new Composite(composite, 0);
        treeView.setLayout((Layout)new FillLayout());
        this.treeViewer = this.createTreeViewer(treeView, counterExample);
        this.rootEditPart = new ScalableRootEditPart();
        this.graphicalViewer = new ScrollingGraphicalViewer();
        this.interactiveView = this.graphicalViewer.createControl(composite);
        this.interactiveView.setBackground(Display.getDefault().getSystemColor(1));
        this.graphicalViewer.setRootEditPart((RootEditPart)this.rootEditPart);
        this.graphicalViewer.setEditPartFactory((EditPartFactory)new CounterExampleEditPartFactory());
        this.graphicalViewer.setContents((Object)counterExample);
        DefaultEditDomain editDomain = new DefaultEditDomain(null);
        editDomain.addViewer((EditPartViewer)this.graphicalViewer);
    }

    public CTabItem getTabitem() {
        return this.tabItem;
    }

    private TableViewer createTableViewer(Composite parent, CounterExample counterExample) {
        CounterExampleTableViewer tableViewer = new CounterExampleTableViewer(parent, 2816);
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLinesVisible(true);
        TableColumnLayout layout = new TableColumnLayout();
        parent.setLayout((Layout)layout);
        this.createEventColumn(tableViewer, layout);
        List propositions = counterExample.getPropositionRoot().getChildren();
        for (CounterExampleProposition proposition : propositions) {
            this.createPropositionColumn(tableViewer, layout, proposition);
        }
        tableViewer.getTable().setToolTipText("Click to show the state in the history");
        tableViewer.getTable().addMouseListener((MouseListener)new CounterExampleTableMouseAdapter(tableViewer, counterExample));
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        tableViewer.setInput(counterExample.getStates());
        return tableViewer;
    }

    private void createEventColumn(TableViewer tableViewer, TableColumnLayout layout) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new TableColumnEventLabelProvider());
        tableViewerColumn.getColumn().setText("Event");
        tableViewerColumn.getColumn().setAlignment(0x1000000);
        layout.setColumnData((Widget)tableViewerColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
    }

    private void createPropositionColumn(TableViewer tableViewer, TableColumnLayout layout, CounterExampleProposition proposition) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new TableColumnValueLabelProvider(proposition));
        tableViewerColumn.getColumn().setText(proposition.toString());
        tableViewerColumn.getColumn().setAlignment(0x1000000);
        layout.setColumnData((Widget)tableViewerColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
    }

    private TreeViewer createTreeViewer(Composite parent, CounterExample counterExample) {
        CounterExampleTreeViewer treeViewer = new CounterExampleTreeViewer(parent, 2816);
        treeViewer.getTree().setHeaderVisible(true);
        treeViewer.getTree().setLinesVisible(true);
        TreeViewerColumn propositionColumn = new TreeViewerColumn((TreeViewer)treeViewer, 0x1000000);
        propositionColumn.setLabelProvider((CellLabelProvider)new TreeColumnPropositionLabelProvider());
        propositionColumn.getColumn().setAlignment(0x1000000);
        propositionColumn.getColumn().setText("Proposition");
        int j = 0;
        while (j < counterExample.getStates().size()) {
            TreeViewerColumn column = new TreeViewerColumn((TreeViewer)treeViewer, 0x1000000);
            column.getColumn().setAlignment(0x1000000);
            CounterExampleState state = (CounterExampleState)counterExample.getStates().get(j);
            column.setLabelProvider((CellLabelProvider)new TreeColumnValueLabelProvider(state));
            Operation operation = state.getOperation();
            if (operation != null) {
                column.getColumn().setText(operation.getName());
            } else {
                column.getColumn().setText("No operation");
            }
            column.getColumn().pack();
            ++j;
        }
        treeViewer.getTree().setToolTipText("Click to show the state in the history");
        treeViewer.getTree().addMouseListener((MouseListener)new CounterExampleTreeMouseAdapter(treeViewer, counterExample));
        treeViewer.setContentProvider((IContentProvider)new CounterExampleContentProvider());
        treeViewer.setInput(Arrays.asList(counterExample.getPropositionRoot()));
        treeViewer.expandAll();
        propositionColumn.getColumn().pack();
        return treeViewer;
    }

    public void printCounterExample(String title) {
        PrintDialog dialog = new PrintDialog(this.graphicalViewer.getControl().getShell(), 0);
        try {
            PrinterData printerData = dialog.open();
            if (printerData != null) {
                PrintGraphicalViewerOperation viewerOperation = new PrintGraphicalViewerOperation(new Printer(printerData), this.graphicalViewer);
                viewerOperation.run(title);
            }
        }
        catch (SWTException e) {
            Logger.notifyUser((String)"Failed to print the LTL counter example.", (Throwable)e);
        }
    }

    public void updateTopControl(CounterExampleViewPart.ViewType viewType) {
        Composite parent;
        Control topControl;
        switch (viewType) {
            case TABLE: {
                topControl = this.tableViewer.getControl();
                break;
            }
            case TREE: {
                topControl = this.treeViewer.getControl();
                break;
            }
            case INTERACTIVE: {
                topControl = this.interactiveView;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected view type in LTL counter-example view");
            }
        }
        this.layout.topControl = topControl;
        if (this.layout.topControl != null && (parent = this.layout.topControl.getParent()) != null) {
            parent.layout();
        }
    }

    public CounterExample getCounterExample() {
        return this.counterExample;
    }

    public void zoomIn() {
        ZoomManager zoomManager = this.rootEditPart.getZoomManager();
        if (zoomManager != null && zoomManager.canZoomIn()) {
            zoomManager.setZoom(zoomManager.getNextZoomLevel());
        }
    }

    public void zoomOut() {
        ZoomManager zoomManager = this.rootEditPart.getZoomManager();
        if (zoomManager != null && zoomManager.canZoomOut()) {
            zoomManager.setZoom(zoomManager.getPreviousZoomLevel());
        }
    }

    protected void stateChanged(State activeState, Operation operation) {
        if (activeState.isInitialized()) {
            List fullPath = this.counterExample.getFullPath();
            Animator animator = Animator.getAnimator();
            History history = animator.getHistory();
            if (this.isCounterExampleLoadedInHistory(this.counterExample)) {
                int initPathSize = this.counterExample.getInitPath().size();
                this.currentIndex = history.getCurrentPosition() - initPathSize;
                if (this.counterExample.getPathType() == LtlCheckingCommand.PathType.INFINITE && this.currentIndex == fullPath.size() - initPathSize) {
                    this.currentIndex = this.counterExample.getLoopEntry();
                }
            }
            this.treeViewer.refresh();
            this.tableViewer.refresh();
            for (EditPart child : this.rootEditPart.getChildren()) {
                child.refresh();
            }
            this.currentIndex = -1;
        }
    }

    private boolean isCounterExampleLoadedInHistory(CounterExample ce) {
        boolean isLoaded;
        List fullPath = ce.getFullPath();
        Animator animator = Animator.getAnimator();
        History history = animator.getHistory();
        ArrayList<HistoryItem> historyItems = new ArrayList<HistoryItem>(Arrays.asList(history.getAllItems()));
        if (!historyItems.isEmpty()) {
            if (((HistoryItem)historyItems.get(historyItems.size() - 1)).getOperation() == null) {
                historyItems.remove(historyItems.size() - 1);
            }
            if (fullPath.size() == historyItems.size()) {
                boolean ceIsEqual = true;
                int i = 0;
                while (i < fullPath.size()) {
                    Operation histOperation;
                    Operation ceOperation = (Operation)fullPath.get(i);
                    if (!ceOperation.equals((Object)(histOperation = ((HistoryItem)historyItems.get(i)).getOperation()))) {
                        ceIsEqual = false;
                        break;
                    }
                    ++i;
                }
                isLoaded = ceIsEqual;
            } else {
                isLoaded = false;
            }
        } else {
            isLoaded = false;
        }
        return isLoaded;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }
}

