/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.ltl;

import de.prob.core.command.LtlCheckingCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.core.domainobjects.ltl.CounterExampleProposition;
import de.prob.core.domainobjects.ltl.CounterExampleState;
import de.prob.core.domainobjects.ltl.CounterExampleValueType;
import de.prob.ui.ltl.CounterExampleFigure;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GroupBoxBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.TitleBarBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public abstract class CounterExamplePropositionFigure
extends Figure
implements MouseListener,
MouseMotionListener {
    protected final CounterExampleProposition model;
    protected final Color foregroundColor = ColorConstants.lightBlue;
    protected final Color backgroundColor = new Color(null, 255, 255, 206);
    protected final Font normalFont = new Font((Device)Display.getDefault(), "Arial", 10, 0);
    protected final Font boldFont = new Font((Device)Display.getDefault(), "Arial", 10, 1);
    protected final int size = 50;
    protected final Hashtable<Integer, Connection> connections = new Hashtable();

    public CounterExamplePropositionFigure(CounterExampleProposition model) {
        this.model = model;
        this.setLayoutManager((LayoutManager)new XYLayout());
        GroupBoxBorder border = new GroupBoxBorder();
        border.setTextColor(this.foregroundColor);
        border.setLabel(model.getFullName());
        border.setFont(this.boldFont);
        this.setBorder((Border)border);
        this.setBackgroundColor(this.backgroundColor);
        this.setOpaque(true);
    }

    public void update() {
        Label label = new Label(this.model.toString());
        label.setForegroundColor(this.foregroundColor);
        this.setToolTip((IFigure)label);
        this.setVisible(true);
        if (this.model.isVisible()) {
            CounterExampleProposition parentModel = this.model.getParent();
            CounterExamplePropositionFigure parent = this.getFigure(parentModel);
            this.drawProposition(parent);
        } else {
            this.setVisible(false);
        }
    }

    protected CounterExamplePropositionFigure getFigure(CounterExampleProposition proposition) {
        IFigure parent;
        if (proposition != null && (parent = this.getParent()) != null) {
            for (IFigure figure : parent.getChildren()) {
                if (!(figure instanceof CounterExamplePropositionFigure) || !((CounterExamplePropositionFigure)figure).getModel().equals(proposition)) continue;
                return (CounterExamplePropositionFigure)figure;
            }
        }
        return null;
    }

    protected void setTrasparent(List<CounterExampleProposition> children) {
        for (CounterExampleProposition child : children) {
            CounterExamplePropositionFigure childFigure = this.getFigure(child);
            for (Connection connection : childFigure.getConnections().values()) {
                connection.setVisible(false);
            }
            child.setVisible(false);
        }
    }

    protected abstract void drawProposition(CounterExamplePropositionFigure var1);

    protected CounterExampleProposition getModel() {
        return this.model;
    }

    protected Color getEllipseColor(CounterExampleValueType value) {
        Color color = ColorConstants.gray;
        if (value.equals((Object)CounterExampleValueType.TRUE)) {
            color = ColorConstants.green;
        } else if (value.equals((Object)CounterExampleValueType.FALSE)) {
            color = ColorConstants.red;
        }
        return color;
    }

    protected String getOperationName(int index) {
        CounterExampleFigure parentFigure = (CounterExampleFigure)this.getParent();
        CounterExample parentModel = parentFigure.getModel();
        List states = parentModel.getStates();
        CounterExampleState state = (CounterExampleState)states.get(index);
        Operation operation = state.getOperation();
        String operationName = operation.getName();
        return operationName;
    }

    protected Hashtable<Integer, Connection> getConnections() {
        return this.connections;
    }

    protected PolylineConnection createLoop(Insets insets, Ellipse source, Ellipse target, int alpha, String operationName, Color loopColor) {
        PolylineConnection connection = new PolylineConnection();
        connection.setAlpha(alpha);
        connection.setAntialias(1);
        connection.setLineWidth(2);
        Label label = new Label(operationName);
        label.setForegroundColor(this.foregroundColor);
        connection.setToolTip((IFigure)label);
        connection.setForegroundColor(loopColor);
        PointList points = new PointList();
        Rectangle sourceBounds = source.getBounds();
        Rectangle targetBounds = target.getBounds();
        points.addPoint(new Point(sourceBounds.x + 50 + insets.left, sourceBounds.y + 25 + insets.top));
        points.addPoint(new Point(sourceBounds.x + 50 + 15 + insets.left, sourceBounds.y + 25 + insets.top));
        points.addPoint(new Point(sourceBounds.x + 50 + 15 + insets.left, sourceBounds.y - 10 + insets.top));
        points.addPoint(new Point(targetBounds.x + 25 + insets.left, targetBounds.y - 10 + insets.top));
        points.addPoint(new Point(targetBounds.x + 25 + insets.left, targetBounds.y + insets.top));
        connection.setPoints(points);
        PolygonDecoration decoration = new PolygonDecoration();
        decoration.setForegroundColor(loopColor);
        decoration.setAlpha(alpha);
        decoration.setAntialias(1);
        PointList decorationPointList = new PointList();
        decorationPointList.addPoint(0, 0);
        decorationPointList.addPoint(-1, 1);
        decorationPointList.addPoint(-1, 0);
        decorationPointList.addPoint(-1, -1);
        decoration.setTemplate(decorationPointList);
        connection.setTargetDecoration((RotatableDecoration)decoration);
        return connection;
    }

    protected Polyline createReduced(Insets insets, Ellipse source, int alpha) {
        Polyline polyline = new Polyline();
        polyline.setAlpha(alpha);
        polyline.setAntialias(1);
        polyline.setLineWidth(2);
        polyline.setToolTip((IFigure)new Label("Reduced"));
        PointList points = new PointList();
        Rectangle sourceBounds = source.getBounds();
        points.addPoint(new Point(sourceBounds.x + 50 + insets.left, sourceBounds.y + 25 + insets.top));
        points.addPoint(new Point(sourceBounds.x + 50 + 15 + insets.left, sourceBounds.y + 25 + insets.top));
        points.addPoint(new Point(sourceBounds.x + 50 + 15 + insets.left, sourceBounds.y + insets.top + 12));
        points.addPoint(new Point(sourceBounds.x + 50 + 15 + insets.left, sourceBounds.y + insets.top + 37));
        polyline.setPoints(points);
        return polyline;
    }

    protected void drawChildParentConnection(Ellipse ellipse, int stateId, CounterExamplePropositionFigure parent) {
        if (this.connections.containsKey(stateId)) {
            this.connections.get(stateId).setVisible(true);
        } else {
            Insets insets = parent.getInsets();
            PolylineConnection connection = new PolylineConnection();
            connection.setAntialias(1);
            connection.setLineStyle(1);
            connection.setLineWidth(2);
            Rectangle sourceBounds = parent.getBounds();
            Rectangle targetBounds = this.getBounds();
            PointList points = new PointList();
            points.addPoint(ellipse.getBounds().x + insets.left + 25, sourceBounds.y + sourceBounds.height);
            points.addPoint(ellipse.getBounds().x + insets.left + 25, targetBounds.y + insets.top);
            connection.setPoints(points);
            PolygonDecoration decoration = new PolygonDecoration();
            decoration.setAntialias(1);
            PointList decorationPointList = new PointList();
            decorationPointList.addPoint(0, 0);
            decorationPointList.addPoint(-1, 1);
            decorationPointList.addPoint(-1, 0);
            decorationPointList.addPoint(-1, -1);
            decoration.setTemplate(decorationPointList);
            connection.setSourceDecoration((RotatableDecoration)decoration);
            this.getParent().add((IFigure)connection);
            this.connections.put(stateId, (Connection)connection);
        }
    }

    protected Panel drawPropositionFigure(CounterExamplePropositionFigure parent, Rectangle bounds, CounterExampleProposition argument, List<Integer> positions, Hashtable<Ellipse, Integer> ellipses1, Hashtable<Integer, Ellipse> ellipses2, Rectangle panelBounds, int stateId, int argumentHeight) {
        ellipses1.clear();
        ellipses2.clear();
        LtlCheckingCommand.PathType pathType = this.model.getPathType();
        List values = argument.getValues();
        Panel panel = new Panel();
        panel.setBounds(panelBounds);
        TitleBarBorder border = new TitleBarBorder();
        border.setBackgroundColor(this.backgroundColor);
        border.setTextColor(this.foregroundColor);
        border.setLabel(argument.toString());
        border.setFont(this.normalFont);
        panel.setBorder((Border)border);
        this.add((IFigure)panel);
        int i = 0;
        while (i < values.size()) {
            this.createColumn(bounds, argument, positions, ellipses1, ellipses2, argumentHeight, pathType, values, panel, i);
            ++i;
        }
        if (parent != null) {
            Ellipse ellipse = ellipses2.get(stateId);
            this.drawChildParentConnection(ellipse, stateId, parent);
        }
        return panel;
    }

    private void createColumn(Rectangle bounds, CounterExampleProposition argument, List<Integer> positions, Hashtable<Ellipse, Integer> ellipses1, Hashtable<Integer, Ellipse> ellipses2, int argumentHeight, LtlCheckingCommand.PathType pathType, List<CounterExampleValueType> values, Panel panel, int i) {
        boolean isLastElement;
        CounterExampleValueType value = values.get(i);
        Ellipse ellipse = new Ellipse();
        if (!positions.contains(i)) {
            ellipse.setAlpha(30);
        }
        ellipse.setAntialias(1);
        ellipse.setLineWidth(2);
        ellipse.setOpaque(true);
        ellipse.addMouseListener((MouseListener)this);
        ellipse.addMouseMotionListener((MouseMotionListener)this);
        ellipse.setBackgroundColor(this.getEllipseColor(value));
        ellipses1.put(ellipse, i);
        ellipses2.put(i, ellipse);
        Label label = new Label(value.toString());
        label.setOpaque(false);
        ellipse.setLayoutManager((LayoutManager)new BorderLayout());
        ellipse.add((IFigure)label, (Object)BorderLayout.CENTER);
        panel.add((IFigure)ellipse);
        int x = (bounds.x + 50) * (i + 1);
        int y = bounds.y + argumentHeight + (pathType == LtlCheckingCommand.PathType.INFINITE ? 5 : 0);
        ellipse.setBounds(new Rectangle(x, y, 50, 50));
        if (i > 0) {
            ChopboxAnchor source = new ChopboxAnchor((IFigure)ellipse);
            Ellipse targetEllipse = ellipses2.get(i - 1);
            if (targetEllipse == null) {
                return;
            }
            ChopboxAnchor target = new ChopboxAnchor((IFigure)targetEllipse);
            PolylineConnection connection = new PolylineConnection();
            connection.setAlpha(30);
            connection.setAntialias(1);
            connection.setLineStyle(1);
            connection.setLineWidth(2);
            connection.setToolTip((IFigure)new Label(this.getOperationName(i - 1)));
            connection.setSourceAnchor((ConnectionAnchor)source);
            connection.setTargetAnchor((ConnectionAnchor)target);
            PolygonDecoration decoration = new PolygonDecoration();
            decoration.setAlpha(30);
            decoration.setAntialias(1);
            PointList decorationPointList = new PointList();
            decorationPointList.addPoint(0, 0);
            decorationPointList.addPoint(-1, 1);
            decorationPointList.addPoint(-1, 0);
            decorationPointList.addPoint(-1, -1);
            decoration.setTemplate(decorationPointList);
            if (positions.contains(i) && positions.contains(i - 1)) {
                connection.setAlpha(250);
                decoration.setAlpha(250);
            }
            if ((this.model.isTransition() || argument.isTransition()) && positions.contains(i - 1)) {
                connection.setAlpha(250);
                decoration.setAlpha(250);
                Color transitionColor = this.getEllipseColor(values.get(i - 1));
                connection.setForegroundColor(transitionColor);
                decoration.setForegroundColor(transitionColor);
            }
            connection.setSourceDecoration((RotatableDecoration)decoration);
            panel.add((IFigure)connection);
        }
        boolean bl = isLastElement = i == values.size() - 1;
        if (isLastElement) {
            this.createEnd(argument, positions, ellipses1, ellipses2, pathType, values, panel, i, ellipse);
        }
    }

    private void createEnd(CounterExampleProposition argument, List<Integer> positions, Hashtable<Ellipse, Integer> ellipses1, Hashtable<Integer, Ellipse> ellipses2, LtlCheckingCommand.PathType pathType, List<CounterExampleValueType> values, Panel panel, int i, Ellipse ellipse) {
        Polyline figure;
        switch (pathType) {
            case INFINITE: {
                boolean highlightLoop;
                String operationName = this.getOperationName(ellipses1.get(ellipse));
                Ellipse target = ellipses2.get(this.model.getLoopEntry());
                int alpha = 30;
                Color loopTransitionColor = ColorConstants.black;
                boolean bl = highlightLoop = positions.contains(i) && positions.contains(i - 1);
                if (highlightLoop) {
                    alpha = 250;
                }
                if ((this.model.isTransition() || argument.isTransition()) && positions.contains(i)) {
                    alpha = 250;
                    loopTransitionColor = this.getEllipseColor(values.get(i));
                }
                figure = this.createLoop(this.getInsets(), ellipse, target, alpha, operationName, loopTransitionColor);
                break;
            }
            case REDUCED: {
                figure = this.createReduced(this.getInsets(), ellipse, positions.contains(i) ? 250 : 30);
                break;
            }
            default: {
                figure = null;
            }
        }
        if (figure != null) {
            panel.add(figure);
        }
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
        me.consume();
        me.consume();
    }

    public void mouseDoubleClicked(MouseEvent me) {
        System.out.println("");
    }

    public void mouseDragged(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mouseHover(MouseEvent me) {
    }

    public void mouseMoved(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
    }

    public static class Alpha {
        public static final int MASKED = 30;
        public static final int HIGHLIGHED = 250;
    }
}

