/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.invcheck;

import de.prob.core.Animator;
import de.prob.core.ProBCommandJob;
import de.prob.core.command.ConstraintBasedInvariantCheckCommand;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.MachineDescription;
import de.prob.ui.invcheck.InvariantCheckDialog;
import de.prob.ui.invcheck.InvariantCheckFinishedListener;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class InvariantCheckHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        Animator animator = Animator.getAnimator();
        if (animator.isMachineLoaded()) {
            this.performInvariantCheck(animator, shell);
        } else {
            MessageDialog.openError((Shell)shell, (String)"Error: No ProB animation running", (String)"To perform a constraint based invariant check, please start the animation of the model first.");
        }
        return null;
    }

    private void performInvariantCheck(Animator animator, Shell shell) throws ExecutionException {
        MachineDescription md = animator.getMachineDescription();
        Collection events = md.getEventNames();
        if (events.isEmpty()) {
            MessageDialog.openError((Shell)shell, (String)"Invariant Check: No Events", (String)"The model does not contain any events to check!");
        } else {
            InvariantCheckDialog dialog = new InvariantCheckDialog(shell, events);
            int status = dialog.open();
            if (status == 0) {
                this.startCheck(animator, dialog.getSelected(), shell);
            }
        }
    }

    private void startCheck(Animator animator, Collection<String> events, Shell shell) throws ExecutionException {
        ConstraintBasedInvariantCheckCommand command = new ConstraintBasedInvariantCheckCommand(events);
        ProBCommandJob job = new ProBCommandJob("Checking for Invariant Preservation", animator, (IComposableCommand)command);
        job.setUser(true);
        job.addJobChangeListener((IJobChangeListener)new InvariantCheckFinishedListener(shell));
        job.schedule();
    }
}

