/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.eventb;

import de.prob.ui.ProBGeneralPreferences;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProBAnimationPreferencePage
extends ProBGeneralPreferences {
    private static final String TITLEERROR = "Unkown name";
    private final Preferences configurationScope;
    private final String configurationId;
    private ConfigNameFieldEditor fdName;
    private MachineFieldEditor fdMachine;
    private ProjectFieldEditor fdProject;

    public ProBAnimationPreferencePage(String configurationName, Preferences configurationStore) {
        super(configurationStore.node(configurationName));
        this.configurationId = configurationName;
        this.configurationScope = configurationStore;
    }

    @Override
    protected Control createContents(Composite parent) {
        Group group = new Group(parent, 16);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        group.setText("General Settings");
        Composite content1 = new Composite((Composite)group, 0);
        content1.setLayout((Layout)new GridLayout(3, false));
        content1.setLayoutData((Object)new GridData(768));
        this.fdName = new ConfigNameFieldEditor("configname", "Name:", content1);
        this.fdName.setPage((DialogPage)this);
        this.fdName.setPropertyChangeListener((IPropertyChangeListener)this);
        this.fdName.fillIntoGrid(content1, 3);
        this.addField((FieldEditor)this.fdName);
        this.getPreferenceStore().setValue("configname", this.getConfigurationScope().node(this.configurationId).get("title", ""));
        this.getPreferenceStore().setDefault("configname", "");
        this.fdProject = new ProjectFieldEditor("projectname", "Project:", content1);
        this.fdProject.setPage((DialogPage)this);
        this.fdProject.setPropertyChangeListener((IPropertyChangeListener)this);
        this.addField((FieldEditor)this.fdProject);
        this.getPreferenceStore().setValue("projectname", this.getConfigurationScope().node(this.configurationId).get("project", ""));
        this.getPreferenceStore().setDefault("projectname", "");
        this.fdMachine = new MachineFieldEditor("machinename", "Machine:", content1);
        this.fdMachine.setPage((DialogPage)this);
        this.fdMachine.setPropertyChangeListener((IPropertyChangeListener)this);
        this.addField((FieldEditor)this.fdMachine);
        this.getPreferenceStore().setValue("machinename", this.getConfigurationScope().node(this.configurationId).get("machine", ""));
        this.getPreferenceStore().setDefault("machinename", "");
        return super.createContents(parent);
    }

    @Override
    public boolean performOk() {
        if (this.fdName != null) {
            this.getConfigNode().put("title", this.fdName.getStringValue());
            this.getContainer().updateTitle();
        }
        if (this.fdProject != null) {
            this.getConfigurationScope().node(this.configurationId).put("project", this.fdProject.getStringValue());
        }
        if (this.fdMachine != null) {
            this.getConfigurationScope().node(this.configurationId).put("machine", this.fdMachine.getStringValue());
        }
        super.performOk();
        return true;
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    public String getTitle() {
        String title = this.getConfigurationScope().node(this.configurationId).get("title", TITLEERROR);
        if (title == TITLEERROR) {
            title = this.configurationId;
        }
        return title;
    }

    private Preferences getConfigNode() {
        return this.getConfigurationScope().node(this.configurationId);
    }

    private Preferences getConfigurationScope() {
        return this.configurationScope;
    }

    private class ConfigNameFieldEditor
    extends StringFieldEditor {
        private static final String nameExistsError = "A configuration with this name already exists!";
        private static final String emptyStringError = "A name is required for this configuration!";

        public ConfigNameFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, UNLIMITED, 0, parent);
        }

        protected boolean doCheckState() {
            if (this.getStringValue().equals(ProBAnimationPreferencePage.this.getConfigNode().get("title", null))) {
                return true;
            }
            if ("".equals(this.getStringValue())) {
                this.setErrorMessage(emptyStringError);
                return false;
            }
            boolean nameExists = false;
            try {
                String[] stringArray = ProBAnimationPreferencePage.this.getConfigurationScope().childrenNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    Preferences node = ProBAnimationPreferencePage.this.getConfigurationScope().node(s);
                    if (node.get("title", null) != null && node.get("title", null).equals(this.getStringValue())) {
                        nameExists = true;
                    }
                    ++n2;
                }
            }
            catch (BackingStoreException backingStoreException) {
                nameExists = true;
            }
            if (this.getStringValue().equals("General Configuration") || nameExists && !this.getStringValue().equals(this.getPreferenceStore().getDefaultString(this.getPreferenceName()))) {
                this.setErrorMessage(nameExistsError);
                return false;
            }
            return true;
        }
    }

    private class MachineFieldEditor
    extends StringButtonFieldEditor {
        private String lastmachine = "";

        public MachineFieldEditor(String name, String labelText, Composite parent) {
            this.init(name, labelText);
            this.setChangeButtonText(JFaceResources.getString((String)"Search..."));
            this.setErrorMessage("Machine not specified.");
            this.setValidateStrategy(0);
            this.createControl(parent);
        }

        protected String changePressed() {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ProBAnimationPreferencePage.this.fdProject.getStringValue());
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new MachineLabelProvider());
            dialog.setTitle("Select Machine");
            dialog.setMessage("Select a machine:");
            try {
                try {
                    ArrayList<IResource> resources = new ArrayList<IResource>();
                    IResource[] iResourceArray = project.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource r = iResourceArray[n2];
                        if (r.getType() == 1 && (r.getFileExtension().equals("bum") || r.getFileExtension().equals("buc"))) {
                            resources.add(r);
                        }
                        ++n2;
                    }
                    dialog.setElements(resources.toArray());
                }
                catch (CoreException coreException) {
                    dialog.open();
                    if (dialog.getResult() != null && dialog.getResult().length > 0) {
                        this.lastmachine = ((IResource)dialog.getResult()[0]).getName();
                    }
                }
            }
            finally {
                dialog.open();
                if (dialog.getResult() != null && dialog.getResult().length > 0) {
                    this.lastmachine = ((IResource)dialog.getResult()[0]).getName();
                }
            }
            return this.lastmachine;
        }
    }

    private static class MachineLabelProvider
    extends LabelProvider {
        private MachineLabelProvider() {
        }

        public Image getImage(Object element) {
            if (((IResource)element).getFileExtension().equals("bum")) {
                return AbstractUIPlugin.imageDescriptorFromPlugin((String)"de.prob.ui", (String)"icons/mch_obj.gif").createImage();
            }
            if (((IResource)element).getFileExtension().equals("buc")) {
                return AbstractUIPlugin.imageDescriptorFromPlugin((String)"de.prob.ui", (String)"icons/ctx_obj.gif").createImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IResource) {
                return ((IResource)element).getName();
            }
            return element == null ? "" : element.toString();
        }
    }

    private static class ProjectFieldEditor
    extends StringButtonFieldEditor {
        private String lastproject;

        public ProjectFieldEditor(String name, String labelText, Composite parent) {
            this.init(name, labelText);
            this.setChangeButtonText(JFaceResources.getString((String)"Browse..."));
            this.setValidateStrategy(0);
            this.setErrorMessage("Project not specified.");
            this.createControl(parent);
        }

        protected String changePressed() {
            ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), null, true, "Select a project:");
            dialog.setTitle("Select Project");
            dialog.open();
            if (dialog.getResult() != null && dialog.getResult().length > 0) {
                this.lastproject = ResourcesPlugin.getWorkspace().getRoot().getProject(dialog.getResult()[0].toString()).getName();
            }
            return this.lastproject;
        }
    }
}

