/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.eventb;

import de.prob.core.LimitedLogger;
import de.prob.logging.Logger;
import de.prob.ui.eventb.ExportNewCoreHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eventb.core.IEventBRoot;
import org.osgi.service.prefs.Preferences;

public class OpenClassicHandler
extends AbstractHandler
implements IHandler {
    private ISelection fSelection;
    private static final String PROB_CLASSIC_NAME = "ProB Tcl/Tk";
    private static final String PROB_STANDALONE_NAME = "ProB Standalone";
    private static final String PROB2_NAME = "ProB2-UI";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.fSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        String prob_location = this.getBinaryLocation();
        if (prob_location == null) {
            Logger.notifyUser((String)"You need to specify a location forProB Standalone. See Preferences -> ProB Standalone.");
        } else {
            IEventBRoot root = this.getSelection();
            if (root != null) {
                if (prob_location.endsWith(".jar")) {
                    String bum_buc_path = root.getResource().getRawLocation().toString();
                    this.runProB2(prob_location, bum_buc_path);
                } else {
                    File temp = this.createTempFile();
                    String tmp = temp.getAbsolutePath();
                    ExportNewCoreHandler.exportToClassic(tmp, root);
                    this.runProBClassic(prob_location, tmp);
                }
            } else {
                Logger.notifyUser((String)"You need to select a context or machine to open with ProB Standalone");
            }
        }
        return null;
    }

    private void runProBClassic(String probBinary, String modelFile) {
        Process process = null;
        try {
            String command = probBinary + " " + modelFile;
            process = Runtime.getRuntime().exec(command);
            BufferedReader output = new BufferedReader(new InputStreamReader(process.getInputStream()));
            new Thread(new ClassicConsole(output)).start();
        }
        catch (IOException e) {
            Logger.notifyUser((String)("You need to specify a correct location for ProB Tcl/Tk. See Preferences -> ProB Standalone.\nProB Tcl/Tk location: " + probBinary + "\nModel file: " + modelFile + "\nError message: " + e.getLocalizedMessage()));
        }
    }

    private void runProB2(String probBinary, String modelFile) {
        try {
            String[] vcommand = new String[]{"java", "-version"};
            ProcessBuilder vpb = new ProcessBuilder(vcommand).redirectErrorStream(true);
            Process vprocess = vpb.start();
            BufferedReader voutput = new BufferedReader(new InputStreamReader(vprocess.getInputStream()));
            new Thread(new ClassicConsole(voutput)).start();
            vprocess.waitFor();
            if (vprocess.exitValue() != 0) {
                Logger.notifyUser((String)("Failed to start java -version. Exit code: " + vprocess.exitValue()));
            }
            String[] command = new String[]{"java", "-jar", probBinary, "--machine-file", modelFile};
            System.out.println("Launching ProB2UI using: java -jar " + probBinary);
            LimitedLogger.getLogger().log("Launching ProB2UI using: java -jar " + probBinary + " --machine-file " + modelFile, "ProB2UI", null);
            ProcessBuilder pb = new ProcessBuilder(command).redirectErrorStream(true);
            Process process = pb.start();
            BufferedReader output = new BufferedReader(new InputStreamReader(process.getInputStream()));
            new Thread(new ClassicConsole(output)).start();
        }
        catch (IOException | InterruptedException e) {
            Logger.notifyUser((String)("You need to specify a correct location for ProB2-UI. See Preferences -> ProB Standalone.\nProB2-UI location: " + probBinary + "\nModel file: " + modelFile + "\nError message: " + e.getLocalizedMessage()));
        }
    }

    private String getBinaryLocation() {
        Preferences preferences = Platform.getPreferencesService().getRootNode().node("instance").node("prob_classic_preferences");
        return preferences.get("location", null);
    }

    private File createTempFile() {
        File temp = null;
        try {
            temp = File.createTempFile("prob_", ".eventb");
            temp.deleteOnExit();
        }
        catch (IOException e) {
            Logger.notifyUser((String)("Something went wrong while saving temp file.\n" + e.getLocalizedMessage()));
        }
        return temp;
    }

    private IEventBRoot getSelection() {
        if (!(this.fSelection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ssel = (IStructuredSelection)this.fSelection;
        if (ssel.size() != 1) {
            return null;
        }
        if (!(ssel.getFirstElement() instanceof IEventBRoot)) {
            return null;
        }
        return (IEventBRoot)ssel.getFirstElement();
    }

    private static final class ClassicConsole
    implements Runnable {
        private final BufferedReader output;

        private ClassicConsole(BufferedReader output) {
            this.output = output;
        }

        @Override
        public void run() {
            block12: {
                try {
                    try {
                        String line;
                        while ((line = this.output.readLine()) != null) {
                            System.out.println("ProB Standalone: " + line);
                            LimitedLogger.getLogger().log(line, OpenClassicHandler.PROB_STANDALONE_NAME, null);
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            this.output.close();
                        }
                        catch (IOException iOException2) {}
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.output.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    this.output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

