/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.eventb;

import de.prob.core.Animator;
import de.prob.core.ProblemHandler;
import de.prob.core.command.ComputeCoverageCommand;
import de.prob.core.command.GetTraceCommand;
import de.prob.core.command.ModelCheckingCommand;
import de.prob.core.command.ReplayTraceCommand;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import de.prob.ui.eventb.ModelCheckingJob;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;

public class ModelCheckingFinishedListener
extends JobChangeAdapter {
    private static final String SEPARATOR_LINE = "===================================================";
    private static final String PLUGIN_ID = "de.prob.ui";
    private final Shell shell;
    private final Animator animator = Animator.getAnimator();

    public ModelCheckingFinishedListener(Shell shell) {
        this.shell = shell;
    }

    public void done(IJobChangeEvent event) {
        super.done(event);
        Job job = event.getJob();
        if (job instanceof ModelCheckingJob) {
            ModelCheckingJob ccJob = (ModelCheckingJob)job;
            this.showResult(ccJob.getModelCheckingResult());
        } else {
            Logger.notifyUser((String)("The job has a wrong type. Expected ModelCheckingJob but got " + String.valueOf(job.getClass())));
        }
    }

    private void showResult(ModelCheckingCommand.Result modelCheckingResult) {
        MultiStatus status = null;
        try {
            status = this.createResult(modelCheckingResult);
        }
        catch (ProBException e) {
            e.notifyUserOnce();
        }
        this.displayResult(status);
    }

    private MultiStatus createResult(ModelCheckingCommand.Result results) throws ProBException {
        if (results == null) {
            ProblemHandler.raiseCommandException((String)"The last result from modelchecker was unexpectely null.");
        }
        ComputeCoverageCommand.ComputeCoverageResult coverage = this.computeCoverage();
        String header_text = "Model Checking finished";
        String text = "";
        switch (results) {
            case ok: {
                text = this.createOkResult();
                break;
            }
            case ok_not_all_nodes_considered: {
                text = this.createOkButNotFinishedResult();
                break;
            }
            case deadlock: {
                List traceDeadlock = GetTraceCommand.getTrace((Animator)this.animator);
                text = this.createDeadlockResult(traceDeadlock);
                this.replayErrorTrace();
                header_text = "Deadlock found!";
                break;
            }
            case invariant_violation: {
                List trace = GetTraceCommand.getTrace((Animator)this.animator);
                text = this.createInvariantViolationResult(trace);
                this.replayErrorTrace();
                header_text = "Invariant Violation found!";
                break;
            }
            case assertion_violation: {
                List atrace = GetTraceCommand.getTrace((Animator)this.animator);
                text = this.createAssertionViolationResult(atrace);
                this.replayErrorTrace();
                header_text = "Theorem Violation found!";
                break;
            }
            case state_error: {
                List setrace = GetTraceCommand.getTrace((Animator)this.animator);
                text = this.createStateErrorResult(setrace);
                this.replayErrorTrace();
                header_text = "State Error found!";
                break;
            }
            case well_definedness_error: {
                List wdtrace = GetTraceCommand.getTrace((Animator)this.animator);
                text = this.createWDErrorResult(wdtrace);
                this.replayErrorTrace();
                header_text = "Well-Definedness Error found!";
                break;
            }
            case general_error: {
                List getrace = GetTraceCommand.getTrace((Animator)this.animator);
                text = this.createGeneralErrorResult(getrace);
                this.replayErrorTrace();
                header_text = "General Error found!";
            }
        }
        MultiStatus info = new MultiStatus(PLUGIN_ID, 1, header_text, null);
        info.add((IStatus)new Status(1, PLUGIN_ID, 1, text, null));
        info.add((IStatus)new Status(1, PLUGIN_ID, 1, SEPARATOR_LINE, null));
        this.appendCoverageStatistics(coverage, PLUGIN_ID, info);
        return info;
    }

    private String createInvariantViolationResult(List<String> trace) {
        StringBuffer sb = new StringBuffer();
        sb.append("Invariant violation found.\n");
        sb.append("ProB has detected a state that violates the invariant.\n");
        return sb.toString();
    }

    private String createAssertionViolationResult(List<String> trace) {
        StringBuffer sb = new StringBuffer();
        sb.append("Theorem violation found.\n");
        sb.append("ProB has detected a state that violates the theorems.\n");
        return sb.toString();
    }

    private String createStateErrorResult(List<String> trace) {
        StringBuffer sb = new StringBuffer();
        sb.append("ProB has detected an erroneous state (e.g., witness error, guard strengthening error).\n");
        return sb.toString();
    }

    private String createWDErrorResult(List<String> trace) {
        StringBuffer sb = new StringBuffer();
        sb.append("ProB has detected a state which caused a well-definedness error(e.g., division by zero).\n");
        return sb.toString();
    }

    private String createGeneralErrorResult(List<String> trace) {
        StringBuffer sb = new StringBuffer();
        sb.append("ProB has detected a state which caused an internal error.\n");
        sb.append("This is probably a bug (please report).\n");
        return sb.toString();
    }

    private String createDeadlockResult(List<String> trace) {
        StringBuffer sb = new StringBuffer();
        sb.append("Deadlock found.\n");
        sb.append("ProB has detected a state where all guards are false.\n");
        return sb.toString();
    }

    private void appendTrace(List<String> trace, StringBuffer sb) {
        for (String s : trace) {
            sb.append(s);
            sb.append('\n');
        }
    }

    private String createOkButNotFinishedResult() {
        return "No errors found, but not all possible states have been visited (Due to animation parameter restrictions).";
    }

    private String createOkResult() {
        return "No errors found\nModel Checking finished, all states visited.\n";
    }

    private void replayErrorTrace() throws ProBException {
        ReplayTraceCommand.replay((Animator)this.animator);
    }

    private void displayResult(final MultiStatus info) {
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError((Shell)ModelCheckingFinishedListener.this.shell, (String)"Model Checking finished", null, (IStatus)info);
            }
        });
    }

    private ComputeCoverageCommand.ComputeCoverageResult computeCoverage() throws ProBException {
        return ComputeCoverageCommand.getCoverage((Animator)this.animator);
    }

    private void appendCoverageStatistics(ComputeCoverageCommand.ComputeCoverageResult coverage, String PID, MultiStatus info) {
        info.add((IStatus)new Status(1, PID, 1, "Coverage statistics:", null));
        info.add((IStatus)new Status(1, PID, 1, "Total Number of States:" + String.valueOf(coverage.getTotalNumberOfNodes()), null));
        info.add((IStatus)new Status(1, PID, 1, "Total Number of Transitions:" + String.valueOf(coverage.getTotalNumberOfTransitions()), null));
        info.add((IStatus)new Status(1, PID, 1, "Node Statistics:", null));
        for (String s : coverage.getNodes()) {
            info.add((IStatus)new Status(1, PID, 1, s, null));
        }
        info.add((IStatus)new Status(1, PID, 1, "Operations Statistics:", null));
        for (String s : coverage.getOps()) {
            info.add((IStatus)new Status(1, PID, 1, s, null));
        }
        info.add((IStatus)new Status(1, PID, 1, "Uncovered Operations:", null));
        for (String s : coverage.getUncovered()) {
            info.add((IStatus)new Status(1, PID, 1, s, null));
        }
    }
}

