/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.eventb;

import de.prob.core.translator.TranslationFailedException;
import de.prob.eventb.translator.TranslatorFactory;
import de.prob.logging.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eventb.core.IEventBRoot;
import org.eventb.core.IMachineRoot;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ExportNewCoreHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell;
        Preferences prefs;
        String fileName;
        IEventBRoot root = this.getSelectedEventBRoot(event);
        if (root != null && (fileName = this.askForExportFile(prefs = Platform.getPreferencesService().getRootNode().node("instance").node("prob_export_preferences"), shell = HandlerUtil.getActiveShell((ExecutionEvent)event), root)) != null) {
            ExportNewCoreHandler.exportToClassic(fileName, root);
        }
        return null;
    }

    private IEventBRoot getSelectedEventBRoot(ExecutionEvent event) {
        IStructuredSelection ssel;
        ISelection fSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IEventBRoot root = null;
        if (fSelection instanceof IStructuredSelection && (ssel = (IStructuredSelection)fSelection).size() == 1 && ssel.getFirstElement() instanceof IEventBRoot) {
            root = (IEventBRoot)ssel.getFirstElement();
        }
        return root;
    }

    private String askForExportFile(Preferences prefs, Shell shell, IEventBRoot root) {
        String path = prefs.get("dir", System.getProperty("user.home"));
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterExtensions(new String[]{"*.eventb"});
        dialog.setFilterPath(path);
        String subext = root instanceof IMachineRoot ? "_mch" : "_ctx";
        dialog.setFileName(root.getComponentName() + subext + ".eventb");
        Object result = dialog.open();
        if (result != null) {
            String newPath = dialog.getFilterPath();
            if (!path.equals(newPath)) {
                prefs.put("dir", newPath);
                try {
                    prefs.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }
            if (!((String)result).endsWith(".eventb")) {
                result = (String)result + ".eventb";
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void exportToClassic(String filename, IEventBRoot root) {
        boolean isSafeToWrite = ExportNewCoreHandler.isSafeToWrite(filename);
        if (!isSafeToWrite) return;
        FileWriter fw = null;
        try {
            fw = new FileWriter(filename);
            TranslatorFactory.translate((IEventBRoot)root, (PrintWriter)new PrintWriter(fw));
            fw.append('\n');
        }
        catch (TranslationFailedException e) {
            e.notifyUserOnce();
            if (fw == null) return;
            try {
                ((Writer)fw).close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException iOException) {
            try {
                Logger.notifyUser((String)("Unable to create file '" + filename + "'"));
                if (fw == null) return;
            }
            catch (Throwable throwable) {
                if (fw == null) throw throwable;
                try {
                    ((Writer)fw).close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                ((Writer)fw).close();
                return;
            }
            catch (IOException iOException3) {}
            return;
        }
        if (fw == null) return;
        try {
            ((Writer)fw).close();
            return;
        }
        catch (IOException iOException) {}
    }

    private static boolean isSafeToWrite(String filename) {
        if (new File(filename).exists()) {
            MessageDialog dialog = new MessageDialog(null, "File exists", null, "The file exists. Do you want to overwrite it?", 3, new String[]{"Yes", "No"}, 0);
            return dialog.open() == 0;
        }
        return true;
    }
}

