/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.errorview;

import de.prob.core.domainobjects.MachineDescription;
import de.prob.core.domainobjects.State;
import de.prob.core.domainobjects.StateError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ShownErrors {
    private MachineDescription description;
    private State state;
    private Collection<ErrorEvent> errorEvents;

    public void update(MachineDescription description, State state) {
        ErrorEvent ee;
        Collection eventErrors;
        Collection errors = state == null ? Collections.EMPTY_LIST : state.getStateBasedErrors();
        HashMap<String, ArrayList<StateError>> emap = new HashMap<String, ArrayList<StateError>>();
        for (StateError error : errors) {
            String event = error.getEvent();
            ArrayList<StateError> evErrors = (ArrayList<StateError>)emap.get(event);
            if (evErrors == null) {
                evErrors = new ArrayList<StateError>();
                emap.put(event, evErrors);
            }
            evErrors.add(error);
        }
        ArrayList<ErrorEvent> errorEvents = new ArrayList<ErrorEvent>();
        for (String string : description.getEventNames()) {
            eventErrors = (Collection)emap.get(string);
            if (eventErrors != null && !eventErrors.isEmpty()) {
                ee = new ErrorEvent(string, this, eventErrors);
                errorEvents.add(ee);
            }
            emap.remove(string);
        }
        for (Map.Entry entry : emap.entrySet()) {
            eventErrors = (Collection)entry.getValue();
            if (eventErrors == null || eventErrors.isEmpty()) continue;
            ee = new ErrorEvent((String)entry.getKey(), this, eventErrors);
            errorEvents.add(ee);
        }
        this.errorEvents = errorEvents;
        this.description = description;
        this.state = state;
    }

    public MachineDescription getDescription() {
        return this.description;
    }

    public State getState() {
        return this.state;
    }

    public Collection<ErrorEvent> getErrorEvents() {
        return this.errorEvents == null ? Collections.EMPTY_LIST : this.errorEvents;
    }

    public static class ErrorEvent {
        public static final ErrorEvent[] EMPTY_ARRAY = new ErrorEvent[0];
        private final String event;
        private final ShownErrors shown;
        private final Collection<ShownStateError> errors;

        public ErrorEvent(String event, ShownErrors shown, Collection<StateError> errors) {
            this.event = event;
            this.shown = shown;
            ArrayList<ShownStateError> es = new ArrayList<ShownStateError>();
            for (StateError se : errors) {
                es.add(new ShownStateError(this, se));
            }
            this.errors = Collections.unmodifiableCollection(es);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o instanceof ErrorEvent) {
                ErrorEvent other = (ErrorEvent)o;
                return this.event.equals(other.event) && this.shown.equals(other.shown);
            }
            return false;
        }

        public int hashCode() {
            return this.event.hashCode();
        }

        public String getEvent() {
            return this.event;
        }

        public Collection<ShownStateError> getErrors() {
            return this.errors;
        }

        public ShownErrors getShownErrors() {
            return this.shown;
        }
    }

    public static class ShownStateError {
        public static final ShownStateError[] EMPTY_ARRAY = new ShownStateError[0];
        private final ErrorEvent event;
        private final StateError error;

        public ShownStateError(ErrorEvent event, StateError error) {
            this.event = event;
            this.error = error;
        }

        public ErrorEvent getEvent() {
            return this.event;
        }

        public StateError getError() {
            return this.error;
        }
    }
}

