/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.deadlock;

import de.prob.core.Animator;
import de.prob.core.ProBJobFinishedListener;
import de.prob.core.command.ConstraintBasedDeadlockCheckCommand;
import de.prob.core.command.ExecuteOperationCommand;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class DeadlockCheckFinishedListener
extends ProBJobFinishedListener {
    private final Shell shell;

    public DeadlockCheckFinishedListener(Shell shell) {
        this.shell = shell;
    }

    protected void showResult(IComposableCommand cmd, Animator animator) {
        String message;
        String dialogTitle;
        int dialogType;
        ConstraintBasedDeadlockCheckCommand command = (ConstraintBasedDeadlockCheckCommand)cmd;
        ConstraintBasedDeadlockCheckCommand.ResultType result = command.getResult();
        if (result == null) {
            dialogType = 1;
            dialogTitle = "Errow During Deadlock Freedom Check";
            message = "ProB did not return a result";
        } else {
            switch (result) {
                case NO_DEADLOCK: {
                    dialogType = 2;
                    dialogTitle = "No Deadlock Found";
                    message = "The model does not contain any deadlock (for current settings of deferred sets).\nIf your model contains deferred sets, there may exist counter-examples for other sizes of these sets.";
                    break;
                }
                case ERROR: {
                    dialogType = 1;
                    dialogTitle = "Errow During Deadlock Freedom Check";
                    message = "An unexpected error occurred while typechecking the given predicate.";
                    break;
                }
                case DEADLOCK_FOUND: {
                    dialogType = 4;
                    dialogTitle = "DEADLOCK FOUND!";
                    message = "The model contains a deadlocking state satisfying the invariant, it will be shown in the state view.\nThe state may not be reachable from the initialisation.";
                    this.displayDeadlock(command, animator);
                    break;
                }
                case INTERRUPTED: {
                    dialogType = 4;
                    dialogTitle = "User Interrupt";
                    message = "The deadlock check has been interrupted by the user or a time-out.";
                    break;
                }
                default: {
                    Logger.notifyUser((String)("Unexpected result: " + String.valueOf(result)));
                    return;
                }
            }
        }
        if (this.shell.isDisposed()) {
            System.out.println("Deadlock freedom check finished: " + dialogTitle);
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    MessageDialog.open((int)dialogType, (Shell)DeadlockCheckFinishedListener.this.shell, (String)dialogTitle, (String)message, (int)0);
                }
            };
            this.shell.getDisplay().asyncExec(runnable);
        }
    }

    private void displayDeadlock(ConstraintBasedDeadlockCheckCommand cmd, Animator animator) {
        Operation operation = cmd.getDeadlockOperation();
        try {
            animator.getHistory().gotoPos(0);
            ExecuteOperationCommand.executeOperation((Animator)animator, (Operation)operation);
        }
        catch (ProBException e) {
            e.notifyUserOnce();
        }
    }
}

