/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.assertion;

import de.prob.core.Animator;
import de.prob.core.LanguageDependendAnimationPart;
import de.prob.core.ProBCommandJob;
import de.prob.core.command.ConstraintBasedDynamicAssertionCheckCommand;
import de.prob.core.command.IComposableCommand;
import de.prob.logging.Logger;
import de.prob.ui.assertion.AssertionDynCheckFinishedListener;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class AssertionDynCheckHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (Animator.getAnimator().isMachineLoaded()) {
            this.performAssertionCheck(shell);
        } else {
            Logger.notifyUser((String)"No ProB animation running. This is a bug. Please submit a report. Error in declaraion for class AssertionDynCheckHandler");
        }
        return null;
    }

    private void performAssertionCheck(Shell shell) throws ExecutionException {
        Animator animator = Animator.getAnimator();
        LanguageDependendAnimationPart ldp = animator.getLanguageDependendPart();
        this.startCheck(animator, ldp, shell);
    }

    private void startCheck(Animator animator, LanguageDependendAnimationPart ldp, Shell shell) throws ExecutionException {
        ConstraintBasedDynamicAssertionCheckCommand command = new ConstraintBasedDynamicAssertionCheckCommand();
        ProBCommandJob job = new ProBCommandJob("Checking Machine Theorems from Invariants Clause", animator, (IComposableCommand)command);
        job.setUser(true);
        job.addJobChangeListener((IJobChangeListener)new AssertionDynCheckFinishedListener(shell));
        job.schedule();
    }
}

