/*
 * Decompiled with CFR 0.152.
 */
package de.prob.eventb.disprover.ui.export;

import de.be4.classicalb.core.parser.analysis.prolog.ASTProlog;
import de.be4.classicalb.core.parser.node.AEventBContextParseUnit;
import de.be4.classicalb.core.parser.node.Switch;
import de.prob.eventb.disprover.core.translation.DisproverContextCreator;
import de.prob.eventb.translator.internal.TranslationVisitor;
import de.prob.logging.Logger;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.output.PrologTermOutput;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eventb.core.EventBPlugin;
import org.eventb.core.IContextRoot;
import org.eventb.core.IEventBRoot;
import org.eventb.core.IMachineRoot;
import org.eventb.core.IPORoot;
import org.eventb.core.IPOSequent;
import org.eventb.core.IPSRoot;
import org.eventb.core.IPSStatus;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.Predicate;
import org.eventb.core.pm.IProofAttempt;
import org.eventb.core.pm.IProofComponent;
import org.eventb.core.pm.IProofManager;
import org.eventb.core.seqprover.IProofTree;
import org.eventb.core.seqprover.IProverSequent;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.rodinp.core.RodinDBException;

public class ExportPOsHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        return this.execute(event, true);
    }

    Object execute(ExecutionEvent event, boolean addTypes) {
        Shell shell;
        Preferences prefs;
        String fileName;
        IEventBRoot root = this.getSelectedEventBRoot(event);
        if (root != null && (fileName = this.askForExportFile(prefs = Platform.getPreferencesService().getRootNode().node("instance").node("prob_export_preferences"), shell = HandlerUtil.getActiveShell((ExecutionEvent)event), root)) != null) {
            ExportPOsHandler.exportPOs(shell, fileName, root, addTypes);
        }
        return null;
    }

    private IEventBRoot getSelectedEventBRoot(ExecutionEvent event) {
        IStructuredSelection ssel;
        ISelection fSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IEventBRoot root = null;
        if (fSelection instanceof IStructuredSelection && (ssel = (IStructuredSelection)fSelection).size() == 1 && ssel.getFirstElement() instanceof IEventBRoot) {
            root = (IEventBRoot)ssel.getFirstElement();
        }
        return root;
    }

    private String askForExportFile(Preferences prefs, Shell shell, IEventBRoot root) {
        String path = prefs.get("dir", System.getProperty("user.home"));
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterExtensions(new String[]{"*.pl"});
        dialog.setFilterPath(path);
        String subext = root instanceof IMachineRoot ? "_mch" : "_ctx";
        dialog.setFileName(root.getComponentName() + subext + ".pl");
        Object result = dialog.open();
        if (result != null) {
            String newPath = dialog.getFilterPath();
            if (!path.equals(newPath)) {
                prefs.put("dir", newPath);
                try {
                    prefs.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }
            if (!((String)result).endsWith(".pl")) {
                result = (String)result + ".pl";
            }
        }
        return result;
    }

    /*
     * Loose catch block
     */
    public static void exportPOs(Shell shell, String filename, IEventBRoot root, boolean addTypes) {
        block18: {
            boolean isSafeToWrite = ExportPOsHandler.isSafeToWrite(filename);
            if (isSafeToWrite) {
                try (PrintWriter fw = null;){
                    try {
                        fw = new PrintWriter(filename);
                        if (root instanceof IContextRoot) {
                            IContextRoot croot = (IContextRoot)root;
                            IPORoot poRoot = croot.getSCContextRoot().getPORoot();
                            IPSRoot psRoot = croot.getSCContextRoot().getPSRoot();
                            ExportPOsHandler.exportPOs(fw, poRoot, psRoot, addTypes);
                        } else if (root instanceof IMachineRoot) {
                            IMachineRoot croot = (IMachineRoot)root;
                            IPORoot poRoot = croot.getSCMachineRoot().getPORoot();
                            IPSRoot psRoot = croot.getSCMachineRoot().getPSRoot();
                            ExportPOsHandler.exportPOs(fw, poRoot, psRoot, addTypes);
                        } else {
                            throw new IllegalArgumentException("Not a Context or Machine root.");
                        }
                        fw.append('\n');
                    }
                    catch (IllegalArgumentException e) {
                        Logger.notifyUser((String)e.getMessage());
                        if (fw != null) {
                            fw.close();
                        }
                    }
                    catch (IOException iOException) {
                        Logger.notifyUser((String)("Unable to create file '" + filename + "'"));
                        if (fw != null) {
                            fw.close();
                        }
                    }
                    catch (RodinDBException rodinDBException) {
                        MessageDialog.openError((Shell)shell, (String)"A RodinDBException Occured", (String)"A RodinDBException occured while fetching sequents. Exported POs might be incomplete.");
                        if (fw != null) {
                            fw.close();
                        }
                        break block18;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                }
            }
        }
    }

    private static void exportPOs(PrintWriter fw, IPORoot poRoot, IPSRoot psRoot, boolean addTypes) throws RodinDBException {
        IPOSequent[] sequents;
        PrologTermOutput pto = new PrologTermOutput(fw, false);
        ASTProlog modelAst = new ASTProlog((IPrologTermOutput)pto, null);
        TranslationVisitor tVisitor = new TranslationVisitor(addTypes);
        Date date = new Date();
        pto.openTerm("generated");
        pto.printNumber(date.getTime());
        pto.printAtom(date.toString());
        pto.closeTerm();
        pto.fullstop();
        pto.openTerm("project_name");
        pto.printAtom(poRoot.getRodinProject().getElementName());
        pto.closeTerm();
        pto.fullstop();
        pto.openTerm("machine_name");
        pto.printAtom(poRoot.getElementName());
        pto.closeTerm();
        pto.fullstop();
        IPOSequent[] iPOSequentArray = sequents = poRoot.getSequents();
        int n = sequents.length;
        int n2 = 0;
        while (n2 < n) {
            IPOSequent ipoSequent = iPOSequentArray[n2];
            IProverSequent proverSequent = ExportPOsHandler.toProverSequent(ipoSequent);
            AEventBContextParseUnit disproverContext = DisproverContextCreator.createDisproverContext((IProverSequent)proverSequent);
            pto.openTerm("disprover_po");
            pto.printAtom(ipoSequent.getElementName());
            disproverContext.apply((Switch)modelAst);
            proverSequent.goal().accept((ISimpleVisitor)tVisitor);
            tVisitor.getPredicate().apply((Switch)modelAst);
            pto.openList();
            for (Predicate hyp : proverSequent.hypIterable()) {
                hyp.accept((ISimpleVisitor)tVisitor);
                tVisitor.getPredicate().apply((Switch)modelAst);
            }
            pto.closeList();
            pto.openList();
            for (Predicate hyp : proverSequent.selectedHypIterable()) {
                hyp.accept((ISimpleVisitor)tVisitor);
                tVisitor.getPredicate().apply((Switch)modelAst);
            }
            pto.closeList();
            IPSStatus status = psRoot.getStatus(ipoSequent.getElementName());
            if (status.getConfidence() == 1000) {
                pto.printAtom("true");
            } else {
                pto.printAtom("unknown");
            }
            pto.closeTerm();
            pto.fullstop();
            ++n2;
        }
    }

    public static IProverSequent toProverSequent(IPOSequent sequent) throws RodinDBException {
        IPORoot poRoot = (IPORoot)sequent.getRoot();
        IProofManager pm = EventBPlugin.getProofManager();
        IProofComponent pc = pm.getProofComponent((IEventBRoot)poRoot);
        IProofAttempt pa = pc.createProofAttempt(sequent.getElementName(), "ProB PO Export", null);
        IProofTree proofTree = pa.getProofTree();
        IProverSequent proverSequent = proofTree.getSequent();
        pa.dispose();
        return proverSequent;
    }

    private static boolean isSafeToWrite(String filename) {
        if (new File(filename).exists()) {
            MessageDialog dialog = new MessageDialog(null, "File exists", null, "The file exists. Do you want to overwrite it?", 3, new String[]{"Yes", "No"}, 0);
            return dialog.open() == 0;
        }
        return true;
    }
}

