/*
 * Decompiled with CFR 0.152.
 */
package de.prob.eventb.disprover.ui;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class DisproverPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Preferences prefNode;
    private Text timeoutTextField;
    private Button checkCLPFD;
    private Button checkCHR;
    private Button checkCSE;
    private Button checkSMT;
    private Button checkDoubleEval;
    private Button checkExportSelectedHyps;

    public DisproverPreferences() {
    }

    public DisproverPreferences(String title) {
        super(title);
    }

    public DisproverPreferences(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite pageComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        pageComponent.setLayout((Layout)layout);
        new Label(pageComponent, 0).setText("Time-out:");
        this.timeoutTextField = new Text(pageComponent, 0);
        int timeout = this.prefNode.getInt("timeout", 1000);
        this.timeoutTextField.setText(Integer.toString(timeout));
        this.timeoutTextField.setSize(100, this.timeoutTextField.getSize().y);
        this.timeoutTextField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.text.length() >= 1) {
                    e.doit = true;
                    int i = 0;
                    while (i < e.text.length()) {
                        if (!Character.isDigit(e.text.charAt(i))) {
                            e.doit = false;
                        }
                        ++i;
                    }
                }
            }
        });
        Label timeoutRemark = new Label(pageComponent, 64);
        timeoutRemark.setText("Note: The time-out is applied to each constraint-solving action.\nThe maximum time-out is thus twice as long (solving with all hypotheses and with the selected hypotheses only).");
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        timeoutRemark.setLayoutData((Object)gridData2);
        new Label(pageComponent, 0).setText("Use CLP(FD) Solver:");
        this.checkCLPFD = new Button(pageComponent, 32);
        this.checkCLPFD.setSelection(this.prefNode.getBoolean("clpfd", true));
        this.checkCLPFD.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!DisproverPreferences.this.checkCLPFD.getSelection()) {
                    DisproverPreferences.this.checkCHR.setSelection(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(pageComponent, 0).setText("Use CHR Solver:");
        this.checkCHR = new Button(pageComponent, 32);
        this.checkCHR.setSelection(this.prefNode.getBoolean("chr", true));
        this.checkCHR.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (DisproverPreferences.this.checkCHR.getSelection()) {
                    DisproverPreferences.this.checkCLPFD.setSelection(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label chrRemark = new Label(pageComponent, 64);
        chrRemark.setText("Note: The CHR Solver can only be used in conjunction with the CLP(FD) solver.");
        chrRemark.setLayoutData((Object)gridData2);
        new Label(pageComponent, 0).setText("Use Common Subexpression Elemination:");
        this.checkCSE = new Button(pageComponent, 32);
        this.checkCSE.setSelection(this.prefNode.getBoolean("cse", false));
        new Label(pageComponent, 0).setText("Enable SMT solver support in ProB interpreter:");
        this.checkSMT = new Button(pageComponent, 32);
        this.checkSMT.setSelection(this.prefNode.getBoolean("smt", false));
        new Label(pageComponent, 0).setText("Check (Hypotheses ^ Goal) in addition to (Hypotheses ^ not Goal) to identify contradiction in hypotheses:");
        this.checkDoubleEval = new Button(pageComponent, 32);
        this.checkDoubleEval.setSelection(this.prefNode.getBoolean("doubleeval", false));
        new Label(pageComponent, 0).setText("Export Goal and selected Hypotheses to B file (/tmp/ProB_Rodin_PO_SelectedHyps.mch):");
        this.checkExportSelectedHyps = new Button(pageComponent, 32);
        this.checkExportSelectedHyps.setSelection(this.prefNode.getBoolean("exportpo", false));
        return pageComponent;
    }

    public boolean performOk() {
        this.prefNode.put("timeout", this.timeoutTextField.getText());
        this.prefNode.putBoolean("clpfd", this.checkCLPFD.getSelection());
        this.prefNode.putBoolean("chr", this.checkCHR.getSelection());
        this.prefNode.putBoolean("cse", this.checkCSE.getSelection());
        this.prefNode.putBoolean("smt", this.checkSMT.getSelection());
        this.prefNode.putBoolean("doubleeval", this.checkDoubleEval.getSelection());
        this.prefNode.putBoolean("exportpo", this.checkExportSelectedHyps.getSelection());
        try {
            this.prefNode.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
        this.prefNode = Platform.getPreferencesService().getRootNode().node("instance").node("prob_disprover_preferences");
    }

    public static final class PushButton
    extends SelectionAdapter {
        private final Text text;
        private final Shell shell;

        public PushButton(Shell shell, Text text) {
            this.shell = shell;
            this.text = text;
        }

        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            FileDialog dialog = new FileDialog(this.shell, 4096);
            String open = dialog.open();
            this.text.setText(open);
        }
    }
}

