/*
 * Decompiled with CFR 0.152.
 */
package de.prob.eventb.disprover.core.internal;

import de.be4.classicalb.core.parser.analysis.prolog.ASTProlog;
import de.be4.classicalb.core.parser.node.AEventBContextParseUnit;
import de.be4.classicalb.core.parser.node.Switch;
import de.prob.core.Animator;
import de.prob.core.ProBCommandJob;
import de.prob.core.command.ClearMachineCommand;
import de.prob.core.command.CommandException;
import de.prob.core.command.ComposedCommand;
import de.prob.core.command.IComposableCommand;
import de.prob.core.command.SetPreferenceCommand;
import de.prob.core.command.SetPreferencesCommand;
import de.prob.core.command.StartAnimationCommand;
import de.prob.eventb.disprover.core.command.DisproverLoadCommand;
import de.prob.eventb.disprover.core.internal.CounterExample;
import de.prob.eventb.disprover.core.internal.ICounterExample;
import de.prob.eventb.translator.internal.TranslationVisitor;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eventb.core.IEventBProject;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.Predicate;
import org.eventb.core.seqprover.IProofMonitor;
import org.osgi.service.prefs.Preferences;

public class DisproverCommand
implements IComposableCommand {
    private static final String RESULT = "Result";
    private CounterExample counterExample;
    private final Set<Predicate> allHypotheses;
    private final Set<Predicate> selectedHypotheses;
    private final Predicate goal;
    private final int timeout;
    private final Boolean exportPO;
    private static ComposedCommand composed;

    public DisproverCommand(Set<Predicate> allHypotheses, Set<Predicate> selectedHypotheses, Predicate goal, int timeout, Boolean exportPO) {
        this.allHypotheses = allHypotheses;
        this.selectedHypotheses = selectedHypotheses;
        this.goal = goal;
        this.timeout = timeout;
        this.exportPO = exportPO;
    }

    public static ICounterExample disprove(Animator animator, IEventBProject project, Set<Predicate> allHypotheses, Set<Predicate> selectedHypotheses, Predicate goal, int timeoutFactor, AEventBContextParseUnit context, IProofMonitor pm) throws InterruptedException {
        Preferences prefNode = Platform.getPreferencesService().getRootNode().node("instance").node("prob_disprover_preferences");
        ClearMachineCommand clear = new ClearMachineCommand();
        SetPreferencesCommand setPrefs = SetPreferencesCommand.createSetPreferencesCommand((Animator)animator);
        SetPreferenceCommand setCLPFD = new SetPreferenceCommand("CLPFD", Boolean.toString(prefNode.getBoolean("clpfd", true)));
        SetPreferenceCommand setCHR = new SetPreferenceCommand("CHR", Boolean.toString(prefNode.getBoolean("chr", true)));
        SetPreferenceCommand setCSE = new SetPreferenceCommand("CSE", Boolean.toString(prefNode.getBoolean("cse", false)));
        SetPreferenceCommand setSMT = new SetPreferenceCommand("SMT_SUPPORTED_INTERPRETER", Boolean.toString(prefNode.getBoolean("smt", false)));
        SetPreferenceCommand setCSEPred = new SetPreferenceCommand("CSE_PRED", Boolean.toString(prefNode.getBoolean("cse", false)));
        SetPreferenceCommand setDoubleEval = new SetPreferenceCommand("DOUBLE_EVALUATION", Boolean.toString(prefNode.getBoolean("doubleeval", true)));
        DisproverLoadCommand load = new DisproverLoadCommand(project, context);
        StartAnimationCommand start = new StartAnimationCommand();
        DisproverCommand disprove = new DisproverCommand(allHypotheses, selectedHypotheses, goal, timeoutFactor * prefNode.getInt("timeout", 1000), prefNode.getBoolean("exportpo", false));
        composed = new ComposedCommand(new IComposableCommand[]{clear, setPrefs, setCLPFD, setCHR, setSMT, setCSE, setCSEPred, setDoubleEval, load, start, disprove});
        ProBCommandJob job = new ProBCommandJob("Disproving", animator, (IComposableCommand)composed);
        job.setUser(true);
        job.schedule();
        while (!(job.getResult() != null || pm != null && pm.isCanceled())) {
            Thread.sleep(200L);
        }
        if (pm != null && pm.isCanceled()) {
            job.cancel();
            throw new InterruptedException();
        }
        return disprove.getResult();
    }

    private ICounterExample getResult() {
        return this.counterExample;
    }

    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("cbc_disprove");
        this.translatePredicate(pto, this.goal);
        pto.openList();
        for (Predicate p : this.allHypotheses) {
            this.translatePredicate(pto, p);
        }
        pto.closeList();
        pto.openList();
        for (Predicate p : this.selectedHypotheses) {
            this.translatePredicate(pto, p);
        }
        pto.closeList();
        pto.printNumber((long)this.timeout);
        if (this.exportPO.booleanValue()) {
            pto.openList();
            pto.openTerm("disprover_option");
            pto.openTerm("export_po_as_machine");
            pto.printAtom("/tmp/ProB_Rodin_PO_SelectedHyps.mch");
            pto.closeTerm();
            pto.closeTerm();
            pto.closeList();
        } else {
            pto.emptyList();
        }
        pto.printVariable(RESULT);
        pto.closeTerm();
    }

    private void translatePredicate(IPrologTermOutput pto, Predicate pred) {
        TranslationVisitor v = new TranslationVisitor();
        pred.accept((ISimpleVisitor)v);
        ASTProlog p = new ASTProlog(pto, null);
        v.getPredicate().apply((Switch)p);
    }

    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        ListPrologTerm vars;
        PrologTerm term = (PrologTerm)bindings.get((Object)RESULT);
        this.counterExample = null;
        if ("time_out".equals(term.getFunctor())) {
            this.counterExample = new CounterExample(false, true, false);
        }
        if ("interrupted".equals(term.getFunctor())) {
            throw new CommandException("Interrupted");
        }
        if ("no_solution_found".equals(term.getFunctor())) {
            PrologTerm reason = term.getArgument(1);
            this.counterExample = reason.hasFunctor("clpfd_overflow", 0) ? new CounterExample(false, false, "CLPFD Integer Overflow") : (reason.hasFunctor("unfixed_deferred_sets", 0) ? new CounterExample(false, false, "unfixed deferred sets in predicate") : new CounterExample(false, false, reason.toString()));
        }
        if ("contradiction_found".equals(term.getFunctor())) {
            this.counterExample = new CounterExample(false, false, false);
            this.counterExample.setProof(true);
        }
        if ("contradiction_in_hypotheses".equals(term.getFunctor())) {
            this.counterExample = new CounterExample(false, false, false);
            this.counterExample.setProof(true);
            this.counterExample.setDoubleCheckFailed(true);
        }
        if ("solution".equals(term.getFunctor())) {
            this.counterExample = new CounterExample(true, false, false);
            vars = (ListPrologTerm)term.getArgument(1);
            for (PrologTerm e : vars) {
                this.counterExample.addVar(e.getArgument(1).getFunctor(), e.getArgument(3).getFunctor());
            }
        }
        if ("solution_on_selected_hypotheses".equals(term.getFunctor())) {
            this.counterExample = new CounterExample(true, false, true);
            vars = (ListPrologTerm)term.getArgument(1);
            for (PrologTerm e : vars) {
                this.counterExample.addVar(e.getArgument(1).getFunctor(), e.getArgument(3).getFunctor());
            }
        }
        if (this.counterExample == null) {
            throw new CommandException("Internal Error in ProB. Unexpected result:" + term.toString());
        }
    }
}

