/*
 * Decompiled with CFR 0.152.
 */
package de.prob.eventb.disprover.core;

import de.be4.classicalb.core.parser.analysis.prolog.ASTProlog;
import de.be4.classicalb.core.parser.node.AEventBContextParseUnit;
import de.be4.classicalb.core.parser.node.Switch;
import de.prob.core.Animator;
import de.prob.eventb.disprover.core.DisproverReasonerInput;
import de.prob.eventb.disprover.core.internal.DisproverCommand;
import de.prob.eventb.disprover.core.internal.ICounterExample;
import de.prob.eventb.disprover.core.translation.DisproverContextCreator;
import de.prob.eventb.translator.internal.TranslationVisitor;
import de.prob.logging.Logger;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.output.PrologTermStringOutput;
import java.util.HashSet;
import org.eventb.core.IEventBProject;
import org.eventb.core.IPOSequent;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.Predicate;
import org.eventb.core.seqprover.IProofMonitor;
import org.eventb.core.seqprover.IProofRule;
import org.eventb.core.seqprover.IProverSequent;
import org.eventb.core.seqprover.IReasoner;
import org.eventb.core.seqprover.IReasonerInput;
import org.eventb.core.seqprover.IReasonerInputReader;
import org.eventb.core.seqprover.IReasonerInputWriter;
import org.eventb.core.seqprover.IReasonerOutput;
import org.eventb.core.seqprover.ProverFactory;
import org.eventb.core.seqprover.SerializeException;
import org.rodinp.core.IRodinProject;
import org.rodinp.core.RodinDBException;

public class DisproverReasoner
implements IReasoner {
    static final String DISPROVER_CONTEXT = "disprover_context";
    private static final String DISPROVER_REASONER_NAME = "de.prob.eventb.disprover.core.disproverReasoner";
    private final int timeoutFactor;

    public DisproverReasoner() {
        this(1);
    }

    public DisproverReasoner(int timeoutFactor) {
        this.timeoutFactor = timeoutFactor;
    }

    public String getReasonerID() {
        return DISPROVER_REASONER_NAME;
    }

    public IReasonerOutput apply(IProverSequent sequent, IReasonerInput input, IProofMonitor pm) {
        try {
            DisproverReasonerInput disproverInput = (DisproverReasonerInput)input;
            ICounterExample ce = this.evaluateSequent(sequent, disproverInput, this.timeoutFactor, pm);
            return this.createDisproverResult(ce, sequent, input);
        }
        catch (RodinDBException e) {
            Logger.log((int)2, (String)e.getMessage(), (Throwable)e);
            return ProverFactory.reasonerFailure((IReasoner)this, (IReasonerInput)input, (String)e.getMessage());
        }
        catch (InterruptedException e) {
            return ProverFactory.reasonerFailure((IReasoner)this, (IReasonerInput)input, (String)e.getMessage());
        }
    }

    private ICounterExample evaluateSequent(IProverSequent sequent, DisproverReasonerInput disproverInput, int timeoutFactor, IProofMonitor pm) throws RodinDBException, InterruptedException {
        IEventBProject evbProject;
        HashSet<Predicate> allHypotheses = new HashSet<Predicate>();
        for (Predicate predicate : sequent.hypIterable()) {
            allHypotheses.add(predicate);
        }
        HashSet<Predicate> selectedHypotheses = new HashSet<Predicate>();
        for (Predicate predicate : sequent.selectedHypIterable()) {
            selectedHypotheses.add(predicate);
        }
        Predicate goal = sequent.goal();
        AEventBContextParseUnit context = DisproverContextCreator.createDisproverContext(sequent);
        IPOSequent origin = (IPOSequent)sequent.getOrigin();
        if (origin == null) {
            System.out.println("No origin available for sequent");
            evbProject = null;
        } else {
            IRodinProject project = origin.getRodinProject();
            evbProject = (IEventBProject)project.getAdapter(IEventBProject.class);
        }
        ICounterExample counterExample = DisproverCommand.disprove(Animator.getAuxAnimator(), evbProject, allHypotheses, selectedHypotheses, goal, timeoutFactor, context, pm);
        Logger.info((String)("Disprover: Result: " + counterExample.toString()));
        return counterExample;
    }

    private String predicateToProlog(Predicate pred) {
        PrologTermStringOutput pto = new PrologTermStringOutput();
        TranslationVisitor v = new TranslationVisitor();
        pred.accept((ISimpleVisitor)v);
        ASTProlog p = new ASTProlog((IPrologTermOutput)pto, null);
        v.getPredicate().apply((Switch)p);
        return pto.toString();
    }

    private IReasonerOutput createDisproverResult(ICounterExample counterExample, IProverSequent sequent, IReasonerInput input) {
        Predicate goal = sequent.goal();
        HashSet<Predicate> usedHyps = new HashSet<Predicate>();
        for (Predicate predicate : sequent.hypIterable()) {
            usedHyps.add(predicate);
        }
        IProofRule.IAntecedent ante = ProverFactory.makeAntecedent((Predicate)goal);
        if (counterExample == null) {
            return ProverFactory.reasonerFailure((IReasoner)this, (IReasonerInput)input, (String)"ProB: Error occurred.");
        }
        if (counterExample.timeoutOccured()) {
            System.out.println(sequent.toString() + ": Timeout occured.");
            return ProverFactory.reasonerFailure((IReasoner)this, (IReasonerInput)input, (String)"ProB: Timeout occurred.");
        }
        if (!counterExample.counterExampleFound() && counterExample.isProof() && !counterExample.doubleCheckFailed()) {
            System.out.println(sequent.toString() + ": Proof.");
            return ProverFactory.makeProofRule((IReasoner)this, (IReasonerInput)input, (Predicate)sequent.goal(), usedHyps, (Integer)1000, (String)"ProB (no enumeration / all cases checked)", (IProofRule.IAntecedent[])new IProofRule.IAntecedent[0]);
        }
        if (!counterExample.counterExampleFound() && counterExample.isProof() && counterExample.doubleCheckFailed()) {
            System.out.println(sequent.toString() + ": Proof.");
            return ProverFactory.makeProofRule((IReasoner)this, (IReasonerInput)input, (Predicate)sequent.goal(), usedHyps, (Integer)1000, (String)"ProB (contradiction in hypotheses)", (IProofRule.IAntecedent[])new IProofRule.IAntecedent[0]);
        }
        if (!counterExample.counterExampleFound()) {
            System.out.println(sequent.toString() + ": Unsure.");
            return ProverFactory.reasonerFailure((IReasoner)this, (IReasonerInput)input, (String)("ProB: No Counter-Example found due to " + counterExample.getReason() + ", but there might exist one."));
        }
        if (counterExample.counterExampleFound() && counterExample.onlySelectedHypotheses()) {
            System.out.println(sequent.toString() + ": Counter-Example for selected hypotheses found.");
            System.out.println(counterExample.toString());
            return ProverFactory.reasonerFailure((IReasoner)this, (IReasonerInput)input, (String)("ProB: Counter-Example to Goal for selected Hypotheses found (may be provable with all Hypotheses): " + counterExample.toString()));
        }
        System.out.println(sequent.toString() + ": Counter-Example found.");
        return ProverFactory.makeProofRule((IReasoner)this, (IReasonerInput)input, (Predicate)sequent.goal(), usedHyps, (Integer)0, (String)counterExample.toString(), (IProofRule.IAntecedent[])new IProofRule.IAntecedent[]{ante});
    }

    public IReasonerInput deserializeInput(IReasonerInputReader reader) throws SerializeException {
        return new DisproverReasonerInput();
    }

    public void serializeInput(IReasonerInput input, IReasonerInputWriter writer) throws SerializeException {
    }
}

