/*
 * Decompiled with CFR 0.152.
 */
package de.prob.eventb.disprover.core.internal;

import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.prob.eventb.translator.internal.TranslationVisitor;
import java.util.ArrayList;
import java.util.List;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.Type;

public class DisproverIdentifier {
    private final String name;
    private final Type type;
    private final boolean givenSet;

    public DisproverIdentifier(String name, Type type, boolean givenSet) {
        this.givenSet = givenSet;
        this.name = name;
        this.type = type;
    }

    public boolean isGivenSet() {
        return this.givenSet;
    }

    public boolean isPrimedVariable() {
        return this.name.endsWith("'");
    }

    private PExpression typeToPExpression(Type type) {
        TranslationVisitor visitor = new TranslationVisitor();
        Expression expression = type.toExpression();
        expression.accept((ISimpleVisitor)visitor);
        PExpression typeExpr = visitor.getExpression();
        return typeExpr;
    }

    public String getName() {
        return this.name;
    }

    public List<TIdentifierLiteral> getId() {
        return this.stringToIdentifierLiteralList(this.name);
    }

    public AIdentifierExpression getIdExpression() {
        return new AIdentifierExpression(this.getId());
    }

    public PExpression getType() {
        if (this.type == null) {
            return null;
        }
        return this.typeToPExpression(this.type);
    }

    private List<TIdentifierLiteral> stringToIdentifierLiteralList(String name) {
        ArrayList<TIdentifierLiteral> identifiers = new ArrayList<TIdentifierLiteral>();
        identifiers.add(new TIdentifierLiteral(name));
        return identifiers;
    }

    public String toString() {
        return this.name + "(" + String.valueOf(this.type) + ")";
    }
}

