/*
 * Decompiled with CFR 0.152.
 */
package de.prob.eventb.disprover.core.translation;

import de.be4.classicalb.core.parser.node.AAxiomsContextClause;
import de.be4.classicalb.core.parser.node.AConstantsContextClause;
import de.be4.classicalb.core.parser.node.ADeferredSetSet;
import de.be4.classicalb.core.parser.node.AEventBContextParseUnit;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AMemberPredicate;
import de.be4.classicalb.core.parser.node.ASetsContextClause;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.prob.eventb.disprover.core.internal.DisproverIdentifier;
import de.prob.eventb.translator.internal.TranslationVisitor;
import java.util.ArrayList;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.ITypeEnvironment;
import org.eventb.core.ast.Predicate;
import org.eventb.core.seqprover.IProverSequent;

public class DisproverContextCreator {
    public static AEventBContextParseUnit createDisproverContext(IProverSequent sequent) {
        return DisproverContextCreator.createDisproverContext((ITypeEnvironment)sequent.typeEnvironment(), sequent.getFormulaFactory(), sequent.hypIterable());
    }

    public static AEventBContextParseUnit createDisproverContext(ITypeEnvironment typeEnvironment, FormulaFactory ff, Iterable<Predicate> hypotheses) {
        AEventBContextParseUnit context = new AEventBContextParseUnit();
        context.setName(new TIdentifierLiteral("DisproverContext"));
        ArrayList<Object> contextClauses = new ArrayList<Object>();
        AConstantsContextClause constantsClause = new AConstantsContextClause();
        ArrayList<AIdentifierExpression> constantsIdentifiers = new ArrayList<AIdentifierExpression>();
        ASetsContextClause setsContextClause = new ASetsContextClause();
        ArrayList<ADeferredSetSet> sets = new ArrayList<ADeferredSetSet>();
        AAxiomsContextClause axiomsContextClause = new AAxiomsContextClause();
        ArrayList<Object> axioms = new ArrayList<Object>();
        ITypeEnvironment.IIterator typeIterator = typeEnvironment.getIterator();
        while (typeIterator.hasNext()) {
            typeIterator.advance();
            DisproverIdentifier id = new DisproverIdentifier(typeIterator.getName(), typeIterator.getType(), typeIterator.isGivenSet());
            if (id.isGivenSet()) {
                sets.add(new ADeferredSetSet(id.getId()));
                continue;
            }
            constantsIdentifiers.add(new AIdentifierExpression(id.getId()));
            axioms.add(new AMemberPredicate((PExpression)id.getIdExpression(), id.getType()));
        }
        TranslationVisitor translator = new TranslationVisitor();
        for (Predicate predicate : hypotheses) {
            predicate.accept((ISimpleVisitor)translator);
            axioms.add(translator.getPredicate());
        }
        axiomsContextClause.setPredicates(axioms);
        contextClauses.add(axiomsContextClause);
        constantsClause.setIdentifiers(constantsIdentifiers);
        contextClauses.add(constantsClause);
        setsContextClause.setSet(sets);
        contextClauses.add(setsContextClause);
        context.setContextClauses(contextClauses);
        return context;
    }
}

