/*
 * Decompiled with CFR 0.152.
 */
package de.prob.eventb.disprover.core.internal;

import de.prob.eventb.disprover.core.internal.ICounterExample;
import java.util.SortedMap;
import java.util.TreeMap;

class CounterExample
implements ICounterExample {
    private final boolean counterExampleFound;
    public final SortedMap<String, String> state = new TreeMap<String, String>();
    private final boolean timeoutOccured;
    private boolean proof = false;
    private boolean doubleCheckFailed = false;
    private boolean selectedHypotheses = false;
    private String reason = "";

    CounterExample(boolean counterExampleFound, boolean timeoutOccured, boolean selectedHypotheses) {
        this.counterExampleFound = counterExampleFound;
        this.timeoutOccured = timeoutOccured;
        this.selectedHypotheses = selectedHypotheses;
    }

    CounterExample(boolean counterExampleFound, boolean timeoutOccured, String reason) {
        this(counterExampleFound, timeoutOccured, false);
        this.reason = reason;
    }

    @Override
    public boolean isProof() {
        return this.proof;
    }

    public void setProof(boolean proof) {
        this.proof = proof;
    }

    @Override
    public boolean counterExampleFound() {
        return this.counterExampleFound;
    }

    public String toString() {
        if (this.counterExampleFound) {
            return "Counter-Example found: " + this.state.toString();
        }
        if (this.isProof()) {
            return "No Counter-Example exists: Proof.";
        }
        if (this.timeoutOccured()) {
            return "No Counter-Example found due to Time-Out.";
        }
        return "No Counter-Example found.";
    }

    void addVar(String name, String value) {
        this.state.put(name, value);
    }

    @Override
    public boolean timeoutOccured() {
        return this.timeoutOccured;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public boolean onlySelectedHypotheses() {
        return this.selectedHypotheses;
    }

    public void setDoubleCheckFailed(boolean b) {
        this.doubleCheckFailed = b;
    }

    @Override
    public boolean doubleCheckFailed() {
        return this.doubleCheckFailed;
    }
}

