/*
 * Decompiled with CFR 0.152.
 */
package de.prob.eventb.disprover.core.command;

import de.be4.classicalb.core.parser.analysis.prolog.ASTProlog;
import de.be4.classicalb.core.parser.node.AEventBContextParseUnit;
import de.be4.classicalb.core.parser.node.Switch;
import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.core.translator.TranslationFailedException;
import de.prob.eventb.translator.Theories;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;
import org.eventb.core.IEventBProject;
import org.rodinp.core.IRodinElement;
import org.rodinp.core.IRodinFile;
import org.rodinp.core.RodinDBException;

public final class DisproverLoadCommand
implements IComposableCommand {
    private final AEventBContextParseUnit context;
    private final IEventBProject project;

    public DisproverLoadCommand(IEventBProject project, AEventBContextParseUnit context) {
        this.context = context;
        this.project = project;
    }

    public void writeCommand(IPrologTermOutput pto) {
        ASTProlog modelAst = new ASTProlog(pto, null);
        try {
            pto.openTerm("load_event_b_project");
            pto.openList();
            pto.closeList();
            pto.openList();
            this.context.apply((Switch)modelAst);
            pto.closeList();
            boolean theoryIsUsed = this.theoriesUsed();
            if (theoryIsUsed) {
                this.theoriesAvailable();
            }
            pto.openList();
            pto.openTerm("exporter_version");
            pto.printNumber(3L);
            pto.closeTerm();
            if (theoryIsUsed) {
                Theories.translate((IEventBProject)this.project, (IPrologTermOutput)pto);
            }
            pto.closeList();
            pto.printVariable("E");
            pto.closeTerm();
        }
        catch (TranslationFailedException e) {
            e.printStackTrace();
        }
    }

    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean theoriesUsed() throws TranslationFailedException {
        try {
            IRodinElement[] elements;
            if (this.project == null) {
                return false;
            }
            IRodinElement[] iRodinElementArray = elements = this.project.getRodinProject().getChildren();
            int n = elements.length;
            int n2 = 0;
            while (true) {
                IRodinFile file;
                String id;
                if (n2 >= n) {
                    return false;
                }
                IRodinElement element = iRodinElementArray[n2];
                if (element instanceof IRodinFile && (id = (file = (IRodinFile)element).getRootElementType().getId()).startsWith("org.eventb.theory.core")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (RodinDBException e) {
            throw new TranslationFailedException((Exception)((Object)e));
        }
    }

    private void theoriesAvailable() throws TranslationFailedException {
        try {
            Theories.touch();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new TranslationFailedException("Theory", "The model to animate makes use of a theory but the theory plug-in is not installed");
        }
    }
}

