/*
 * Decompiled with CFR 0.152.
 */
package de.prob.sap.commands;

import de.prob.core.Animator;
import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.exceptions.ProBException;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.AIntegerPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.sap.commands.GlobalTestcaseResult;
import de.prob.sap.exceptions.ParseProblemException;
import de.prob.sap.util.FormulaUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eventb.core.IMachineRoot;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.IParseResult;
import org.eventb.core.ast.ITypeCheckResult;
import org.eventb.core.ast.ITypeEnvironment;
import org.eventb.core.ast.ITypeEnvironmentBuilder;
import org.eventb.core.ast.Predicate;

public class GenerateTestcaseCommand
implements IComposableCommand {
    private static final String UNCOVERED_EVENTS = "UncoveredEvents";
    private static final String NUMBER_TESTCASES = "NrTestcases";
    private final Collection<String> operationNames;
    private final Predicate targetPredicate;
    private final int maxDepth;
    private final int maxNodes;
    private final String filename;
    private GlobalTestcaseResult result;

    public GenerateTestcaseCommand(Collection<String> operationNames, Predicate targetPredicate, int maxDepth, int maxNodes, String filename) {
        this.operationNames = operationNames;
        this.targetPredicate = targetPredicate;
        this.maxDepth = maxDepth;
        this.maxNodes = maxNodes;
        this.filename = filename;
    }

    public static GlobalTestcaseResult generateTestcases(IMachineRoot machineRoot, Collection<String> operationNames, String targetPredicate, int maxDepth, int maxNodes, String filename) throws CoreException, ProBException {
        Predicate predicate = GenerateTestcaseCommand.parsePredicate(machineRoot, targetPredicate);
        return GenerateTestcaseCommand.generateTestcases(operationNames, predicate, maxDepth, maxNodes, filename);
    }

    private static GlobalTestcaseResult generateTestcases(Collection<String> events, Predicate predicate, int maxDepth, int maxNodes, String filename) throws ProBException {
        Animator animator = Animator.getAnimator();
        GenerateTestcaseCommand command = new GenerateTestcaseCommand(events, predicate, maxDepth, maxNodes, filename);
        animator.execute(command);
        return command.result;
    }

    private static Predicate parsePredicate(IMachineRoot machineRoot, String targetPredicate) throws ParseProblemException, CoreException {
        ITypeEnvironmentBuilder typeEnv;
        FormulaFactory formfact = FormulaFactory.getDefault();
        IParseResult parsedPredicate = formfact.parsePredicate(targetPredicate, null);
        if (parsedPredicate.hasProblem()) {
            throw new ParseProblemException(parsedPredicate.getProblems());
        }
        Predicate predicate = parsedPredicate.getParsedPredicate();
        ITypeCheckResult tcr = predicate.typeCheck((ITypeEnvironment)(typeEnv = machineRoot.getSCMachineRoot().getTypeEnvironment()));
        if (tcr.hasProblem()) {
            throw new ParseProblemException(tcr.getProblems());
        }
        return predicate;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        AIntegerPrologTerm pNumberTests = (AIntegerPrologTerm)bindings.get((Object)NUMBER_TESTCASES);
        int numberOfTests = pNumberTests.intValueExact();
        ListPrologTerm pEvents = (ListPrologTerm)bindings.get((Object)UNCOVERED_EVENTS);
        ArrayList<String> uncovered = new ArrayList<String>(pEvents.size());
        for (PrologTerm term : pEvents) {
            String event = PrologTerm.atomicString((PrologTerm)term);
            uncovered.add(event);
        }
        this.result = new GlobalTestcaseResult(numberOfTests, uncovered);
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("sap_generate_testcases");
        pto.openList();
        for (String op : this.operationNames) {
            pto.printAtom(op);
        }
        pto.closeList();
        FormulaUtils.printPredicate(this.targetPredicate, pto);
        pto.printNumber((long)this.maxDepth).printNumber((long)this.maxNodes).printAtom(this.filename);
        pto.printVariable(NUMBER_TESTCASES).printVariable(UNCOVERED_EVENTS);
        pto.closeTerm();
    }
}

