/*
 * Decompiled with CFR 0.152.
 */
package de.prob.sap.commands;

import de.prob.core.Animator;
import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.exceptions.ProBException;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.AIntegerPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.sap.commands.LocalTestcasesResult;

public class GenerateLocalTestcasesCommand
implements IComposableCommand {
    private final String global;
    private final String local;
    private final int maxNodes;
    private LocalTestcasesResult result;

    public GenerateLocalTestcasesCommand(String global, String local, int maxNodes) {
        this.global = global;
        this.local = local;
        this.maxNodes = maxNodes;
    }

    public static LocalTestcasesResult generateTestcases(String globalFilename, String localFilename, int maxNodes) throws ProBException {
        GenerateLocalTestcasesCommand command = new GenerateLocalTestcasesCommand(globalFilename, localFilename, maxNodes);
        Animator.getAnimator().execute(command);
        return command.result;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        int sat = ((AIntegerPrologTerm)bindings.get((Object)"SAT")).intValueExact();
        int unsat = ((AIntegerPrologTerm)bindings.get((Object)"UNSAT")).intValueExact();
        this.result = new LocalTestcasesResult(sat, unsat);
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("sap_generate_testcases").printAtom(this.global).printAtom(this.local).printNumber((long)this.maxNodes).printVariable("SAT").printVariable("UNSAT").closeTerm();
    }
}

