/*
 * Decompiled with CFR 0.152.
 */
package de.prob.eventb.translator.internal;

import de.prob.core.translator.TranslationFailedException;
import de.prob.eventb.translator.ContextTranslator;
import de.prob.eventb.translator.internal.EventBTranslator;
import de.prob.eventb.translator.internal.ModelTranslator;
import de.prob.prolog.output.IPrologTermOutput;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eventb.core.IEventBRoot;
import org.eventb.core.ISCInternalContext;
import org.eventb.core.ISCMachineRoot;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.ITypeEnvironment;
import org.eventb.core.ast.ITypeEnvironmentBuilder;
import org.rodinp.core.IRodinFile;

public final class EventBMachineTranslator
extends EventBTranslator {
    private final ISCMachineRoot machine;

    public static void create(ISCMachineRoot machine, IPrologTermOutput pto) throws TranslationFailedException {
        EventBMachineTranslator translator = new EventBMachineTranslator(machine);
        translator.constructTranslation(pto);
    }

    private EventBMachineTranslator(ISCMachineRoot machine) {
        super((IEventBRoot)machine);
        this.machine = machine;
    }

    private void constructTranslation(IPrologTermOutput pto) throws TranslationFailedException {
        List<ISCMachineRoot> roots = this.collectRefinementChain();
        List<ModelTranslator> mchTranslators = this.getModelTranslators(roots);
        List<ContextTranslator> ctxTranslators = this.getContextTranslators(roots);
        this.printProlog(mchTranslators, ctxTranslators, pto);
    }

    private List<ISCMachineRoot> collectRefinementChain() throws TranslationFailedException {
        ArrayList<ISCMachineRoot> roots = new ArrayList<ISCMachineRoot>();
        try {
            this.buildRefinementChain(this.machine, roots);
        }
        catch (CoreException e) {
            throw new TranslationFailedException((Exception)((Object)e));
        }
        return roots;
    }

    private void buildRefinementChain(ISCMachineRoot element, List<ISCMachineRoot> list) throws CoreException {
        IRodinFile[] abst;
        list.add(element);
        IRodinFile[] iRodinFileArray = abst = element.getAbstractSCMachines();
        int n = abst.length;
        int n2 = 0;
        while (n2 < n) {
            IRodinFile rodinFile = iRodinFileArray[n2];
            this.buildRefinementChain((ISCMachineRoot)rodinFile.getRoot(), list);
            ++n2;
        }
    }

    private List<ModelTranslator> getModelTranslators(List<ISCMachineRoot> roots) throws TranslationFailedException {
        ArrayList<ModelTranslator> mchTranslators = new ArrayList<ModelTranslator>();
        for (ISCMachineRoot iscMachineRoot : roots) {
            mchTranslators.add(ModelTranslator.create(iscMachineRoot));
        }
        return mchTranslators;
    }

    private List<ContextTranslator> getContextTranslators(List<ISCMachineRoot> models) throws TranslationFailedException {
        ArrayList<ContextTranslator> translators = new ArrayList<ContextTranslator>();
        ArrayList<String> processed = new ArrayList<String>();
        for (ISCMachineRoot m : models) {
            try {
                ISCInternalContext[] seenContexts;
                FormulaFactory ff = m.getFormulaFactory();
                ITypeEnvironmentBuilder te = m.getTypeEnvironment();
                ISCInternalContext[] iSCInternalContextArray = seenContexts = m.getSCSeenContexts();
                int n = seenContexts.length;
                int n2 = 0;
                while (n2 < n) {
                    ISCInternalContext seenContext = iSCInternalContextArray[n2];
                    this.collectContexts(translators, processed, seenContext, ff, (ITypeEnvironment)te);
                    ++n2;
                }
            }
            catch (CoreException e) {
                throw new TranslationFailedException((Exception)((Object)e));
            }
        }
        return translators;
    }

    private void collectContexts(List<ContextTranslator> translatorMap, List<String> processed, ISCInternalContext context, FormulaFactory ff, ITypeEnvironment te) throws TranslationFailedException {
        String name = context.getElementName();
        if (!processed.contains(name)) {
            processed.add(name);
            translatorMap.add(ContextTranslator.create(context, ff, te));
        }
    }
}

