/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.types;

import de.prob.core.types.ProbDataType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class TypedIdentifier {
    private final String name;
    private final ProbDataType type;
    private final Collection<String> sections;

    public TypedIdentifier(String name, ProbDataType type, String[] sections) {
        if (name == null || type == null) {
            throw new IllegalArgumentException("Name and type of a typed identifier must not be null");
        }
        this.name = name;
        this.type = type;
        this.sections = sections == null ? Collections.emptyList() : Collections.unmodifiableCollection(Arrays.asList(sections));
    }

    public String getName() {
        return this.name;
    }

    public ProbDataType getType() {
        return this.type;
    }

    public Collection<String> getSections() {
        return this.sections;
    }

    public boolean equals(Object other) {
        boolean isEqual;
        if (this == other) {
            isEqual = true;
        } else {
            if (other != null && other instanceof TypedIdentifier) {
                TypedIdentifier ti = (TypedIdentifier)other;
                return this.name.equals(ti.name) && this.type.equals(ti.type);
            }
            isEqual = false;
        }
        return isEqual;
    }

    public int hashCode() {
        return (this.name.hashCode() * 23 + this.type.hashCode()) * 11 + 24;
    }
}

