/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.types;

import de.prob.core.types.ProbDataType;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class RecordProbType
extends ProbDataType {
    private final SortedMap<String, ProbDataType> fields;

    public RecordProbType(Map<String, ProbDataType> fields) {
        if (fields == null) {
            throw new IllegalArgumentException("fields must not be null");
        }
        if (fields.containsValue(null)) {
            String invalidField = RecordProbType.getNullField(fields);
            throw new IllegalArgumentException("field " + invalidField + " has null type");
        }
        this.fields = new TreeMap<String, ProbDataType>(fields);
    }

    private static String getNullField(Map<String, ProbDataType> fields) {
        for (Map.Entry<String, ProbDataType> entry : fields.entrySet()) {
            if (entry.getValue() != null) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("no null field found");
    }

    @Override
    public int getOperatorPriority() {
        return 500;
    }

    @Override
    public void prettyprint(StringBuilder builder) {
        builder.append("struct(");
        boolean first = true;
        for (Map.Entry<String, ProbDataType> entry : this.fields.entrySet()) {
            if (!first) {
                builder.append(',');
            }
            builder.append(entry.getKey());
            builder.append(':');
            RecordProbType.printWithParenthesis(builder, entry.getValue(), 81);
            first = false;
        }
        builder.append(')');
    }

    public boolean equals(Object other) {
        boolean isEqual = other == this ? true : (other != null && other instanceof RecordProbType ? this.fields.equals(((RecordProbType)other).fields) : false);
        return isEqual;
    }

    public int hashCode() {
        return this.fields.hashCode() * 17 + 2;
    }
}

