/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.langdep;

import de.be4.classicalb.core.parser.analysis.prolog.ASTProlog;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.Switch;
import de.prob.core.Animator;
import de.prob.core.LanguageDependendAnimationPart;
import de.prob.core.command.LoadEventBModelCommand;
import de.prob.eventb.translator.internal.TranslationVisitor;
import de.prob.exceptions.ProBException;
import de.prob.parserbase.ProBParseException;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.unicode.UnicodeTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eventb.core.IContextRoot;
import org.eventb.core.IEventBRoot;
import org.eventb.core.IMachineRoot;
import org.eventb.core.ISCContextRoot;
import org.eventb.core.ISCEvent;
import org.eventb.core.ISCIdentifierElement;
import org.eventb.core.ISCMachineRoot;
import org.eventb.core.ISCParameter;
import org.eventb.core.ISCVariable;
import org.eventb.core.ast.ASTProblem;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.IInferredTypeEnvironment;
import org.eventb.core.ast.IParseResult;
import org.eventb.core.ast.ITypeCheckResult;
import org.eventb.core.ast.ITypeEnvironment;
import org.eventb.core.ast.ITypeEnvironmentBuilder;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.Type;
import org.rodinp.core.IRodinFile;
import org.rodinp.core.RodinDBException;

public class EventBAnimatorPart
implements LanguageDependendAnimationPart {
    private static final String EXPR_WRAPPER = "bexpr";
    private static final String PRED_WRAPPER = "bpred";
    private static final String TRANS_WRAPPER = "btrans";
    private final IEventBRoot root;

    public EventBAnimatorPart(IEventBRoot root) {
        this.root = root;
    }

    public void parseExpression(IPrologTermOutput pto, String expression1, boolean wrap) throws ProBParseException {
        String expression = UnicodeTranslator.toUnicode((String)expression1);
        FormulaFactory ff = this.root.getFormulaFactory();
        IParseResult parseResult = ff.parseExpression(expression, null);
        this.checkParseResult(parseResult);
        Expression ee = parseResult.getParsedExpression();
        this.typeCheck(ff, (Formula<?>)ee);
        PExpression expr = TranslationVisitor.translateExpression(ee);
        this.toPrologTerm(pto, (Node)expr, wrap, EXPR_WRAPPER);
    }

    public void parsePredicate(IPrologTermOutput pto, String predicate1, boolean wrap) throws ProBParseException {
        String predicate = UnicodeTranslator.toUnicode((String)predicate1);
        FormulaFactory ff = this.root.getFormulaFactory();
        IParseResult parseResult = ff.parsePredicate(predicate, null);
        this.checkParseResult(parseResult);
        Predicate pp = parseResult.getParsedPredicate();
        this.typeCheck(ff, (Formula<?>)pp);
        PPredicate apred = TranslationVisitor.translatePredicate(pp);
        this.toPrologTerm(pto, (Node)apred, wrap, PRED_WRAPPER);
    }

    private void toPrologTerm(IPrologTermOutput pto, Node formulaNode, boolean wrap, String wrapper) throws ProBParseException {
        if (wrap) {
            pto.openTerm(wrapper);
        }
        ASTProlog prolog = new ASTProlog(pto, null);
        formulaNode.apply((Switch)prolog);
        if (wrap) {
            pto.closeTerm();
        }
    }

    private void typeCheck(FormulaFactory ff, Formula<?> pp) throws ProBParseException {
        this.typeCheck(pp, this.getTypeEnvironment(ff));
    }

    private void typeCheck(Formula<?> pp, ITypeEnvironment typeEnvironment) throws ProBParseException {
        ITypeCheckResult tcr = pp.typeCheck(typeEnvironment);
        if (tcr.hasProblem()) {
            List problems = tcr.getProblems();
            ASTProblem problem = (ASTProblem)problems.iterator().next();
            throw new ProBParseException(problem.toString());
        }
        IInferredTypeEnvironment inferred = tcr.getInferredEnvironment();
        if (!inferred.isEmpty()) {
            Set names = inferred.getNames();
            throw new ProBParseException("unknown identifier: " + names.toString());
        }
    }

    private ITypeEnvironment getTypeEnvironment(FormulaFactory ff) throws ProBParseException {
        ITypeEnvironmentBuilder typeEnv = null;
        try {
            if (this.root instanceof IMachineRoot) {
                typeEnv = this.root.getSCMachineRoot().getTypeEnvironment();
            }
            if (this.root instanceof ISCMachineRoot) {
                typeEnv = this.root.getSCMachineRoot().getTypeEnvironment();
            }
            if (this.root instanceof IContextRoot) {
                typeEnv = this.root.getSCContextRoot().getTypeEnvironment();
            }
            if (this.root instanceof ISCContextRoot) {
                typeEnv = this.root.getSCContextRoot().getTypeEnvironment();
            }
        }
        catch (CoreException e) {
            throw this.rodin2parseException(e);
        }
        return typeEnv;
    }

    private void checkParseResult(IParseResult parseResult) throws ProBParseException {
        if (parseResult.hasProblem()) {
            throw new ProBParseException(parseResult.getProblems().toString());
        }
    }

    @Override
    public void reload(Animator animator) throws ProBException {
        LoadEventBModelCommand.load(animator, this.root);
    }

    public void parseTransitionPredicate(IPrologTermOutput pto, String transPredicate, boolean wrap) throws ProBParseException, UnsupportedOperationException {
        String predicate;
        String event;
        if (this.root instanceof IMachineRoot) {
            int sepIndex = transPredicate.indexOf("|");
            if (sepIndex < 0) {
                event = transPredicate.trim();
                predicate = null;
            } else {
                event = transPredicate.substring(0, sepIndex).trim();
                predicate = transPredicate.substring(sepIndex + 1);
            }
        } else {
            throw new UnsupportedOperationException("predicates on transitions are only supported when animating machines");
        }
        this.parseTransition(pto, wrap, event, predicate);
    }

    private void parseTransition(IPrologTermOutput pto, boolean wrap, String eventName, String predicateString) throws ProBParseException {
        ISCEvent event = this.getEvent(eventName);
        Predicate predicate = predicateString == null ? null : this.parseTransPredicate(predicateString, event);
        this.printTransPred(pto, wrap, eventName, predicate);
    }

    private ISCEvent getEvent(String eventName) throws ProBParseException {
        ISCMachineRoot machine = ((IMachineRoot)this.root).getSCMachineRoot();
        try {
            ISCEvent[] iSCEventArray = machine.getSCEvents();
            int n = iSCEventArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISCEvent event = iSCEventArray[n2];
                if (Objects.equals(event.getLabel(), eventName)) {
                    return event;
                }
                ++n2;
            }
            throw new ProBParseException("unknown event " + eventName);
        }
        catch (RodinDBException e) {
            throw this.rodin2parseException((CoreException)((Object)e));
        }
    }

    private Predicate parseTransPredicate(String predicateString, ISCEvent event) throws ProBParseException {
        String utf8String = UnicodeTranslator.toUnicode((String)predicateString);
        FormulaFactory ff = this.root.getFormulaFactory();
        IParseResult parseResult = ff.parsePredicate(utf8String, null);
        this.checkParseResult(parseResult);
        Predicate predicate = parseResult.getParsedPredicate();
        ITypeEnvironmentBuilder typeEnv = ff.makeTypeEnvironment();
        typeEnv.addAll(this.getTypeEnvironment(ff));
        this.addEventParameters(event, ff, typeEnv, new ArrayList<String>());
        ISCMachineRoot machine = ((IMachineRoot)this.root).getSCMachineRoot();
        this.addPostStateVariables(machine, ff, typeEnv, new ArrayList<String>());
        this.typeCheck((Formula<?>)predicate, (ITypeEnvironment)typeEnv);
        return predicate;
    }

    private void addPostStateVariables(ISCMachineRoot machine, FormulaFactory ff, ITypeEnvironmentBuilder typeEnv, ArrayList<String> allVariables) throws ProBParseException {
        try {
            ISCVariable[] variables = machine.getSCVariables();
            this.addAllIdentifiers(ff, typeEnv, allVariables, (ISCIdentifierElement[])variables, "'");
            IRodinFile[] iRodinFileArray = machine.getAbstractSCMachines();
            int n = iRodinFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRodinFile refMachine = iRodinFileArray[n2];
                ISCMachineRoot absMachine = (ISCMachineRoot)refMachine.getRoot();
                this.addPostStateVariables(absMachine, ff, typeEnv, allVariables);
                ++n2;
            }
        }
        catch (CoreException e) {
            throw this.rodin2parseException(e);
        }
    }

    private void addEventParameters(ISCEvent event, FormulaFactory ff, ITypeEnvironmentBuilder typeEnv, Collection<String> allParameters) throws ProBParseException {
        try {
            ISCParameter[] params = event.getSCParameters();
            this.addAllIdentifiers(ff, typeEnv, allParameters, (ISCIdentifierElement[])params, "");
        }
        catch (CoreException e) {
            throw this.rodin2parseException(e);
        }
    }

    private void addAllIdentifiers(FormulaFactory ff, ITypeEnvironmentBuilder typeEnv, Collection<String> allParameters, ISCIdentifierElement[] ids, String postfix) throws CoreException {
        ISCIdentifierElement[] iSCIdentifierElementArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            ISCIdentifierElement identifier = iSCIdentifierElementArray[n2];
            String name = identifier.getIdentifierString() + postfix;
            if (!allParameters.contains(name)) {
                Type type = identifier.getType(ff);
                typeEnv.addName(name, type);
                allParameters.add(name);
            }
            ++n2;
        }
    }

    private ProBParseException rodin2parseException(CoreException e) {
        return new ProBParseException("Error in the underlying Rodin Database.\nTry cleaning your workspace.\n Details: " + e.getLocalizedMessage());
    }

    private void printTransPred(IPrologTermOutput pto, boolean wrap, String eventName, Predicate predicate) {
        if (wrap) {
            pto.openTerm(TRANS_WRAPPER);
        }
        pto.openTerm("event");
        pto.printAtom(eventName);
        if (predicate != null) {
            PPredicate apred = TranslationVisitor.translatePredicate(predicate);
            ASTProlog prolog = new ASTProlog(pto, null);
            apred.apply((Switch)prolog);
        }
        pto.closeTerm();
        if (wrap) {
            pto.closeTerm();
        }
    }
}

