/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.internal;

import de.prob.cli.CliException;
import de.prob.cli.CliStarter;
import de.prob.core.ProblemHandler;
import de.prob.core.sablecc.node.ACallBackResult;
import de.prob.core.sablecc.node.AProgressResult;
import de.prob.core.sablecc.node.PResult;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import de.prob.parser.ProBResultParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.Charset;

public class ServerConnection {
    private Socket socket = null;
    private BufferedInputStream inputStream = null;
    private PrintStream outputStream = null;
    private CliStarter cli = null;
    private volatile boolean shutdown = true;

    private void startcli(File file) throws CliException {
        this.cli = new CliStarter(file);
    }

    private void establishConnection(int port) throws CliException {
        try {
            this.socket = new Socket(InetAddress.getByName(null), port);
            this.inputStream = new BufferedInputStream(this.socket.getInputStream());
            this.outputStream = new PrintStream(this.socket.getOutputStream());
        }
        catch (IOException e) {
            block8: {
                if (this.socket != null) {
                    try {
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {
                            Logger.info(e.getLocalizedMessage());
                            this.socket = null;
                            this.inputStream = null;
                            this.outputStream = null;
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        this.socket = null;
                        this.inputStream = null;
                        this.outputStream = null;
                        throw throwable;
                    }
                    this.socket = null;
                    this.inputStream = null;
                    this.outputStream = null;
                }
            }
            throw new CliException("Opening connection to ProB server failed", e, false);
        }
    }

    public PResult sendCommand(String commandString) throws ProBException {
        if (this.shutdown) {
            ProblemHandler.raiseCliException("probcli is currently shutting down");
        }
        this.checkState();
        this.sendQuery(commandString);
        PResult topnode = ProBResultParser.parse((String)this.getAnswer()).getPResult();
        while (topnode instanceof AProgressResult || topnode instanceof ACallBackResult) {
            if (topnode instanceof ACallBackResult) {
                this.sendQuery("call_back_not_supported.");
            }
            topnode = ProBResultParser.parse((String)this.getAnswer()).getPResult();
        }
        return topnode;
    }

    private void sendQuery(String commandString) throws ProBException {
        Logger.assertProB("commandString.trim().endsWith(\".\")", commandString.trim().endsWith("."));
        this.outputStream.println(commandString);
        this.outputStream.flush();
    }

    private String getAnswer() throws ProBException {
        String input = null;
        try {
            input = this.readAnswer();
            if (input == null) {
                throw new IOException("ProB binary returned nothing - it might have crashed");
            }
        }
        catch (IOException e) {
            this.shutdown();
            String message = "Exception while reading from socket";
            ProblemHandler.handleCliException(message, e);
        }
        return input;
    }

    protected String readAnswer() throws IOException {
        StringBuilder result = new StringBuilder();
        byte[] buffer = new byte[1024];
        boolean done = false;
        while (!done) {
            int count = this.inputStream.read(buffer);
            if (count > 0) {
                if (buffer[count - 1] == 1) {
                    done = true;
                    --count;
                }
                String s = new String(buffer, 0, count, Charset.defaultCharset().name());
                result.append(s.replace("\r", "").replace("\n", ""));
                continue;
            }
            done = true;
        }
        return result.length() > 0 ? result.toString() : null;
    }

    public void startup(File file) throws CliException {
        if (this.shutdown) {
            this.startcli(file);
            this.establishConnection(this.cli.getPort());
            this.shutdown = false;
        } else {
            Logger.notifyUser("Tried to start a server that is already running");
        }
    }

    public void shutdown() {
        if (!this.shutdown) {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    Logger.info(e.getLocalizedMessage());
                }
            }
            this.socket = null;
            this.inputStream = null;
            this.outputStream = null;
            this.cli.shutdown();
            this.cli = null;
            this.shutdown = true;
        }
    }

    private void checkState() throws CliException {
        if (this.inputStream == null || this.outputStream == null) {
            ProblemHandler.raiseCliException("Stream to ProB server not ready");
        }
    }

    public void sendUserInterruptSignal() {
        if (this.cli != null) {
            this.cli.sendUserInterruptReference();
        }
    }
}

